/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PaymentFormMethod;
import telegram4j.tl.api.TlObject;

public final class ImmutablePaymentFormMethod
implements PaymentFormMethod {
    private final int identifier;
    private final String url;
    private final String title;

    private ImmutablePaymentFormMethod(String url, String title) {
        this.url = Objects.requireNonNull(url, "url");
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = PaymentFormMethod.super.identifier();
    }

    private ImmutablePaymentFormMethod(Builder builder) {
        this.url = builder.url;
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PaymentFormMethod.super.identifier();
    }

    private ImmutablePaymentFormMethod(int identifier, String url, String title) {
        this.identifier = identifier;
        this.url = url;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutablePaymentFormMethod withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePaymentFormMethod(value, this.url, this.title);
    }

    public final ImmutablePaymentFormMethod withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentFormMethod(this.identifier, newValue, this.title);
    }

    public final ImmutablePaymentFormMethod withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentFormMethod(this.identifier, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentFormMethod && this.equalTo(0, (ImmutablePaymentFormMethod)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaymentFormMethod another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "PaymentFormMethod{identifier=" + this.identifier + ", url=" + this.url + ", title=" + this.title + "}";
    }

    public static ImmutablePaymentFormMethod of(String url, String title) {
        return new ImmutablePaymentFormMethod(url, title);
    }

    public static ImmutablePaymentFormMethod copyOf(PaymentFormMethod instance) {
        if (instance instanceof ImmutablePaymentFormMethod) {
            return (ImmutablePaymentFormMethod)instance;
        }
        return ImmutablePaymentFormMethod.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private String title;

        private Builder() {
        }

        public final Builder from(PaymentFormMethod instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaymentFormMethod instance;
            long bits = 0L;
            if (object instanceof PaymentFormMethod) {
                instance = (PaymentFormMethod)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePaymentFormMethod build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaymentFormMethod(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build PaymentFormMethod, some of required attributes are not set " + attributes;
        }
    }
}

