/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.PostAddress;
import telegram4j.tl.api.TlObject;

public final class ImmutablePaymentRequestedInfo
implements PaymentRequestedInfo {
    private final int identifier;
    private final int flags;
    @Nullable
    private final String name;
    @Nullable
    private final String phone;
    @Nullable
    private final String email;
    @Nullable
    private final PostAddress shippingAddress;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePaymentRequestedInfo INSTANCE = ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo());

    private ImmutablePaymentRequestedInfo() {
        this.name = null;
        this.phone = null;
        this.email = null;
        this.shippingAddress = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePaymentRequestedInfo(Builder builder) {
        this.name = builder.name;
        this.phone = builder.phone;
        this.email = builder.email;
        this.shippingAddress = builder.shippingAddress;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePaymentRequestedInfo(int identifier, int flags, @Nullable String name, @Nullable String phone, @Nullable String email, @Nullable PostAddress shippingAddress) {
        this.identifier = identifier;
        this.flags = flags;
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.shippingAddress = shippingAddress;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PaymentRequestedInfo.super.identifier();
    }

    private int flagsInitialize() {
        return PaymentRequestedInfo.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String phone() {
        return this.phone;
    }

    @Override
    @Nullable
    public String email() {
        return this.email;
    }

    @Override
    @Nullable
    public PostAddress shippingAddress() {
        return this.shippingAddress;
    }

    public final ImmutablePaymentRequestedInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(value, this.flags, this.name, this.phone, this.email, this.shippingAddress));
    }

    public final ImmutablePaymentRequestedInfo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(this.identifier, value, this.name, this.phone, this.email, this.shippingAddress));
    }

    public final ImmutablePaymentRequestedInfo withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(this.identifier, this.flags, value, this.phone, this.email, this.shippingAddress));
    }

    public final ImmutablePaymentRequestedInfo withPhone(@Nullable String value) {
        if (Objects.equals(this.phone, value)) {
            return this;
        }
        return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(this.identifier, this.flags, this.name, value, this.email, this.shippingAddress));
    }

    public final ImmutablePaymentRequestedInfo withEmail(@Nullable String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(this.identifier, this.flags, this.name, this.phone, value, this.shippingAddress));
    }

    public final ImmutablePaymentRequestedInfo withShippingAddress(@Nullable PostAddress value) {
        if (this.shippingAddress == value) {
            return this;
        }
        return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(this.identifier, this.flags, this.name, this.phone, this.email, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentRequestedInfo && this.equalTo(0, (ImmutablePaymentRequestedInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaymentRequestedInfo another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.name, another.name) && Objects.equals(this.phone, another.phone) && Objects.equals(this.email, another.email) && Objects.equals(this.shippingAddress, another.shippingAddress);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.phone);
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.shippingAddress);
        return h;
    }

    public String toString() {
        return "PaymentRequestedInfo{identifier=" + this.identifier + ", flags=" + this.flags + ", name=" + this.name + ", phone=" + this.phone + ", email=" + this.email + ", shippingAddress=" + this.shippingAddress + "}";
    }

    public static ImmutablePaymentRequestedInfo of() {
        return INSTANCE;
    }

    private static ImmutablePaymentRequestedInfo validate(ImmutablePaymentRequestedInfo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePaymentRequestedInfo copyOf(PaymentRequestedInfo instance) {
        if (instance instanceof ImmutablePaymentRequestedInfo) {
            return (ImmutablePaymentRequestedInfo)instance;
        }
        return ImmutablePaymentRequestedInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private String name;
        private String phone;
        private String email;
        private PostAddress shippingAddress;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaymentRequestedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PaymentRequestedInfo) {
                String emailValue;
                String phoneValue;
                PostAddress shippingAddressValue;
                instance = (PaymentRequestedInfo)object;
                this.flags(instance.flags());
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((shippingAddressValue = instance.shippingAddress()) != null) {
                    this.shippingAddress(shippingAddressValue);
                }
                if ((phoneValue = instance.phone()) != null) {
                    this.phone(phoneValue);
                }
                if ((emailValue = instance.email()) != null) {
                    this.email(emailValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder phone(@Nullable String phone) {
            this.phone = phone;
            return this;
        }

        public final Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        public final Builder shippingAddress(@Nullable PostAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public ImmutablePaymentRequestedInfo build() {
            return ImmutablePaymentRequestedInfo.validate(new ImmutablePaymentRequestedInfo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePaymentRequestedInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePaymentRequestedInfo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PaymentRequestedInfo, attribute initializers form cycle " + attributes;
        }
    }
}

