/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PaymentSavedCredentials;
import telegram4j.tl.api.TlObject;

public final class ImmutablePaymentSavedCredentials
implements PaymentSavedCredentials {
    private final int identifier;
    private final String id;
    private final String title;

    private ImmutablePaymentSavedCredentials(String id, String title) {
        this.id = Objects.requireNonNull(id, "id");
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = PaymentSavedCredentials.super.identifier();
    }

    private ImmutablePaymentSavedCredentials(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PaymentSavedCredentials.super.identifier();
    }

    private ImmutablePaymentSavedCredentials(int identifier, String id, String title) {
        this.identifier = identifier;
        this.id = id;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutablePaymentSavedCredentials withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePaymentSavedCredentials(value, this.id, this.title);
    }

    public final ImmutablePaymentSavedCredentials withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentSavedCredentials(this.identifier, newValue, this.title);
    }

    public final ImmutablePaymentSavedCredentials withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentSavedCredentials(this.identifier, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentSavedCredentials && this.equalTo(0, (ImmutablePaymentSavedCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaymentSavedCredentials another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "PaymentSavedCredentials{identifier=" + this.identifier + ", id=" + this.id + ", title=" + this.title + "}";
    }

    public static ImmutablePaymentSavedCredentials of(String id, String title) {
        return new ImmutablePaymentSavedCredentials(id, title);
    }

    public static ImmutablePaymentSavedCredentials copyOf(PaymentSavedCredentials instance) {
        if (instance instanceof ImmutablePaymentSavedCredentials) {
            return (ImmutablePaymentSavedCredentials)instance;
        }
        return ImmutablePaymentSavedCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String id;
        private String title;

        private Builder() {
        }

        public final Builder from(PaymentSavedCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaymentSavedCredentials instance;
            long bits = 0L;
            if (object instanceof PaymentSavedCredentials) {
                instance = (PaymentSavedCredentials)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePaymentSavedCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaymentSavedCredentials(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build PaymentSavedCredentials, some of required attributes are not set " + attributes;
        }
    }
}

