/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerBlocked;
import telegram4j.tl.api.TlObject;

public final class ImmutablePeerBlocked
implements PeerBlocked {
    private final int identifier;
    private final Peer peerId;
    private final int date;

    private ImmutablePeerBlocked(Peer peerId, int date) {
        this.peerId = Objects.requireNonNull(peerId, "peerId");
        this.date = date;
        this.identifier = PeerBlocked.super.identifier();
    }

    private ImmutablePeerBlocked(Builder builder) {
        this.peerId = builder.peerId;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PeerBlocked.super.identifier();
    }

    private ImmutablePeerBlocked(int identifier, Peer peerId, int date) {
        this.identifier = identifier;
        this.peerId = peerId;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peerId() {
        return this.peerId;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutablePeerBlocked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePeerBlocked(value, this.peerId, this.date);
    }

    public final ImmutablePeerBlocked withPeerId(Peer value) {
        if (this.peerId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peerId");
        return new ImmutablePeerBlocked(this.identifier, newValue, this.date);
    }

    public final ImmutablePeerBlocked withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutablePeerBlocked(this.identifier, this.peerId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePeerBlocked && this.equalTo(0, (ImmutablePeerBlocked)another);
    }

    private boolean equalTo(int synthetic, ImmutablePeerBlocked another) {
        return this.identifier == another.identifier && this.peerId.equals(another.peerId) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peerId.hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "PeerBlocked{identifier=" + this.identifier + ", peerId=" + this.peerId + ", date=" + this.date + "}";
    }

    public static ImmutablePeerBlocked of(Peer peerId, int date) {
        return new ImmutablePeerBlocked(peerId, date);
    }

    public static ImmutablePeerBlocked copyOf(PeerBlocked instance) {
        if (instance instanceof ImmutablePeerBlocked) {
            return (ImmutablePeerBlocked)instance;
        }
        return ImmutablePeerBlocked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peerId;
        private int date;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PeerBlocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PeerBlocked) {
                instance = (PeerBlocked)object;
                this.peerId(instance.peerId());
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peerId(Peer peerId) {
            this.peerId = Objects.requireNonNull(peerId, "peerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePeerBlocked build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePeerBlocked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peerId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build PeerBlocked, some of required attributes are not set " + attributes;
        }
    }
}

