/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.NotificationSound;
import telegram4j.tl.PeerNotifySettings;
import telegram4j.tl.api.TlObject;

public final class ImmutablePeerNotifySettings
implements PeerNotifySettings {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Boolean showPreviews;
    @Nullable
    private final Boolean silent;
    @Nullable
    private final Integer muteUntil;
    @Nullable
    private final NotificationSound iosSound;
    @Nullable
    private final NotificationSound androidSound;
    @Nullable
    private final NotificationSound otherSound;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePeerNotifySettings INSTANCE = ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings());

    private ImmutablePeerNotifySettings() {
        this.showPreviews = null;
        this.silent = null;
        this.muteUntil = null;
        this.iosSound = null;
        this.androidSound = null;
        this.otherSound = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePeerNotifySettings(Builder builder) {
        this.showPreviews = builder.showPreviews;
        this.silent = builder.silent;
        this.muteUntil = builder.muteUntil;
        this.iosSound = builder.iosSound;
        this.androidSound = builder.androidSound;
        this.otherSound = builder.otherSound;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePeerNotifySettings(int identifier, int flags, @Nullable Boolean showPreviews, @Nullable Boolean silent, @Nullable Integer muteUntil, @Nullable NotificationSound iosSound, @Nullable NotificationSound androidSound, @Nullable NotificationSound otherSound) {
        this.identifier = identifier;
        this.flags = flags;
        this.showPreviews = showPreviews;
        this.silent = silent;
        this.muteUntil = muteUntil;
        this.iosSound = iosSound;
        this.androidSound = androidSound;
        this.otherSound = otherSound;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PeerNotifySettings.super.identifier();
    }

    private int flagsInitialize() {
        return PeerNotifySettings.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Boolean showPreviews() {
        return this.showPreviews;
    }

    @Override
    @Nullable
    public Boolean silent() {
        return this.silent;
    }

    @Override
    @Nullable
    public Integer muteUntil() {
        return this.muteUntil;
    }

    @Override
    @Nullable
    public NotificationSound iosSound() {
        return this.iosSound;
    }

    @Override
    @Nullable
    public NotificationSound androidSound() {
        return this.androidSound;
    }

    @Override
    @Nullable
    public NotificationSound otherSound() {
        return this.otherSound;
    }

    public final ImmutablePeerNotifySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(value, this.flags, this.showPreviews, this.silent, this.muteUntil, this.iosSound, this.androidSound, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, value, this.showPreviews, this.silent, this.muteUntil, this.iosSound, this.androidSound, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withShowPreviews(@Nullable Boolean value) {
        if (Objects.equals(this.showPreviews, value)) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, this.flags, value, this.silent, this.muteUntil, this.iosSound, this.androidSound, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withSilent(@Nullable Boolean value) {
        if (Objects.equals(this.silent, value)) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, this.flags, this.showPreviews, value, this.muteUntil, this.iosSound, this.androidSound, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withMuteUntil(@Nullable Integer value) {
        if (Objects.equals(this.muteUntil, value)) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, this.flags, this.showPreviews, this.silent, value, this.iosSound, this.androidSound, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withIosSound(@Nullable NotificationSound value) {
        if (this.iosSound == value) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, this.flags, this.showPreviews, this.silent, this.muteUntil, value, this.androidSound, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withAndroidSound(@Nullable NotificationSound value) {
        if (this.androidSound == value) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, this.flags, this.showPreviews, this.silent, this.muteUntil, this.iosSound, value, this.otherSound));
    }

    public final ImmutablePeerNotifySettings withOtherSound(@Nullable NotificationSound value) {
        if (this.otherSound == value) {
            return this;
        }
        return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this.identifier, this.flags, this.showPreviews, this.silent, this.muteUntil, this.iosSound, this.androidSound, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePeerNotifySettings && this.equalTo(0, (ImmutablePeerNotifySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutablePeerNotifySettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.showPreviews, another.showPreviews) && Objects.equals(this.silent, another.silent) && Objects.equals(this.muteUntil, another.muteUntil) && Objects.equals(this.iosSound, another.iosSound) && Objects.equals(this.androidSound, another.androidSound) && Objects.equals(this.otherSound, another.otherSound);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.showPreviews);
        h += (h << 5) + Objects.hashCode(this.silent);
        h += (h << 5) + Objects.hashCode(this.muteUntil);
        h += (h << 5) + Objects.hashCode(this.iosSound);
        h += (h << 5) + Objects.hashCode(this.androidSound);
        h += (h << 5) + Objects.hashCode(this.otherSound);
        return h;
    }

    public String toString() {
        return "PeerNotifySettings{identifier=" + this.identifier + ", flags=" + this.flags + ", showPreviews=" + this.showPreviews + ", silent=" + this.silent + ", muteUntil=" + this.muteUntil + ", iosSound=" + this.iosSound + ", androidSound=" + this.androidSound + ", otherSound=" + this.otherSound + "}";
    }

    public static ImmutablePeerNotifySettings of() {
        return INSTANCE;
    }

    private static ImmutablePeerNotifySettings validate(ImmutablePeerNotifySettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePeerNotifySettings copyOf(PeerNotifySettings instance) {
        if (instance instanceof ImmutablePeerNotifySettings) {
            return (ImmutablePeerNotifySettings)instance;
        }
        return ImmutablePeerNotifySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Boolean showPreviews;
        private Boolean silent;
        private Integer muteUntil;
        private NotificationSound iosSound;
        private NotificationSound androidSound;
        private NotificationSound otherSound;

        private Builder() {
        }

        public final Builder from(PeerNotifySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PeerNotifySettings instance;
            long bits = 0L;
            if (object instanceof PeerNotifySettings) {
                Integer muteUntilValue;
                NotificationSound otherSoundValue;
                Boolean showPreviewsValue;
                Boolean silentValue;
                instance = (PeerNotifySettings)object;
                NotificationSound iosSoundValue = instance.iosSound();
                if (iosSoundValue != null) {
                    this.iosSound(iosSoundValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((silentValue = instance.silent()) != null) {
                    this.silent(silentValue);
                }
                if ((showPreviewsValue = instance.showPreviews()) != null) {
                    this.showPreviews(showPreviewsValue);
                }
                if ((otherSoundValue = instance.otherSound()) != null) {
                    this.otherSound(otherSoundValue);
                }
                this.flags(instance.flags());
                NotificationSound androidSoundValue = instance.androidSound();
                if (androidSoundValue != null) {
                    this.androidSound(androidSoundValue);
                }
                if ((muteUntilValue = instance.muteUntil()) != null) {
                    this.muteUntil(muteUntilValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder showPreviews(@Nullable Boolean showPreviews) {
            this.showPreviews = showPreviews;
            return this;
        }

        public final Builder silent(@Nullable Boolean silent) {
            this.silent = silent;
            return this;
        }

        public final Builder muteUntil(@Nullable Integer muteUntil) {
            this.muteUntil = muteUntil;
            return this;
        }

        public final Builder iosSound(@Nullable NotificationSound iosSound) {
            this.iosSound = iosSound;
            return this;
        }

        public final Builder androidSound(@Nullable NotificationSound androidSound) {
            this.androidSound = androidSound;
            return this;
        }

        public final Builder otherSound(@Nullable NotificationSound otherSound) {
            this.otherSound = otherSound;
            return this;
        }

        public ImmutablePeerNotifySettings build() {
            return ImmutablePeerNotifySettings.validate(new ImmutablePeerNotifySettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePeerNotifySettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePeerNotifySettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PeerNotifySettings, attribute initializers form cycle " + attributes;
        }
    }
}

