/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PeerLocated;
import telegram4j.tl.PeerSelfLocated;
import telegram4j.tl.api.TlObject;

public final class ImmutablePeerSelfLocated
implements PeerSelfLocated {
    private final int identifier;
    private final int expires;

    private ImmutablePeerSelfLocated(int expires) {
        this.expires = expires;
        this.identifier = PeerSelfLocated.super.identifier();
    }

    private ImmutablePeerSelfLocated(Builder builder) {
        this.expires = builder.expires;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PeerSelfLocated.super.identifier();
    }

    private ImmutablePeerSelfLocated(int identifier, int expires) {
        this.identifier = identifier;
        this.expires = expires;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    public final ImmutablePeerSelfLocated withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePeerSelfLocated(value, this.expires);
    }

    public final ImmutablePeerSelfLocated withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutablePeerSelfLocated(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePeerSelfLocated && this.equalTo(0, (ImmutablePeerSelfLocated)another);
    }

    private boolean equalTo(int synthetic, ImmutablePeerSelfLocated another) {
        return this.identifier == another.identifier && this.expires == another.expires;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.expires;
        return h;
    }

    public String toString() {
        return "PeerSelfLocated{identifier=" + this.identifier + ", expires=" + this.expires + "}";
    }

    public static ImmutablePeerSelfLocated of(int expires) {
        return new ImmutablePeerSelfLocated(expires);
    }

    public static ImmutablePeerSelfLocated copyOf(PeerSelfLocated instance) {
        if (instance instanceof ImmutablePeerSelfLocated) {
            return (ImmutablePeerSelfLocated)instance;
        }
        return ImmutablePeerSelfLocated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXPIRES = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int expires;

        private Builder() {
        }

        public final Builder from(PeerLocated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PeerSelfLocated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PeerLocated instance;
            long bits = 0L;
            if (object instanceof PeerLocated) {
                instance = (PeerLocated)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PeerSelfLocated) {
                instance = (PeerSelfLocated)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePeerSelfLocated build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePeerSelfLocated(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build PeerSelfLocated, some of required attributes are not set " + attributes;
        }
    }
}

