/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PeerSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutablePeerSettings
implements PeerSettings {
    private final int identifier;
    private final int flags;
    private final boolean reportSpam;
    private final boolean addContact;
    private final boolean blockContact;
    private final boolean shareContact;
    private final boolean needContactsException;
    private final boolean reportGeo;
    private final boolean autoarchived;
    private final boolean inviteMembers;
    private final boolean requestChatBroadcast;
    @Nullable
    private final Integer geoDistance;
    @Nullable
    private final String requestChatTitle;
    @Nullable
    private final Integer requestChatDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePeerSettings INSTANCE = ImmutablePeerSettings.validate(new ImmutablePeerSettings());

    private ImmutablePeerSettings() {
        this.geoDistance = null;
        this.requestChatTitle = null;
        this.requestChatDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.reportSpam = this.initShim.reportSpam();
        this.addContact = this.initShim.addContact();
        this.blockContact = this.initShim.blockContact();
        this.shareContact = this.initShim.shareContact();
        this.needContactsException = this.initShim.needContactsException();
        this.reportGeo = this.initShim.reportGeo();
        this.autoarchived = this.initShim.autoarchived();
        this.inviteMembers = this.initShim.inviteMembers();
        this.requestChatBroadcast = this.initShim.requestChatBroadcast();
        this.initShim = null;
    }

    private ImmutablePeerSettings(Builder builder) {
        this.geoDistance = builder.geoDistance;
        this.requestChatTitle = builder.requestChatTitle;
        this.requestChatDate = builder.requestChatDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.reportSpamIsSet()) {
            this.initShim.reportSpam(builder.reportSpam);
        }
        if (builder.addContactIsSet()) {
            this.initShim.addContact(builder.addContact);
        }
        if (builder.blockContactIsSet()) {
            this.initShim.blockContact(builder.blockContact);
        }
        if (builder.shareContactIsSet()) {
            this.initShim.shareContact(builder.shareContact);
        }
        if (builder.needContactsExceptionIsSet()) {
            this.initShim.needContactsException(builder.needContactsException);
        }
        if (builder.reportGeoIsSet()) {
            this.initShim.reportGeo(builder.reportGeo);
        }
        if (builder.autoarchivedIsSet()) {
            this.initShim.autoarchived(builder.autoarchived);
        }
        if (builder.inviteMembersIsSet()) {
            this.initShim.inviteMembers(builder.inviteMembers);
        }
        if (builder.requestChatBroadcastIsSet()) {
            this.initShim.requestChatBroadcast(builder.requestChatBroadcast);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.reportSpam = this.initShim.reportSpam();
        this.addContact = this.initShim.addContact();
        this.blockContact = this.initShim.blockContact();
        this.shareContact = this.initShim.shareContact();
        this.needContactsException = this.initShim.needContactsException();
        this.reportGeo = this.initShim.reportGeo();
        this.autoarchived = this.initShim.autoarchived();
        this.inviteMembers = this.initShim.inviteMembers();
        this.requestChatBroadcast = this.initShim.requestChatBroadcast();
        this.initShim = null;
    }

    private ImmutablePeerSettings(int identifier, int flags, boolean reportSpam, boolean addContact, boolean blockContact, boolean shareContact, boolean needContactsException, boolean reportGeo, boolean autoarchived, boolean inviteMembers, boolean requestChatBroadcast, @Nullable Integer geoDistance, @Nullable String requestChatTitle, @Nullable Integer requestChatDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.reportSpam = reportSpam;
        this.addContact = addContact;
        this.blockContact = blockContact;
        this.shareContact = shareContact;
        this.needContactsException = needContactsException;
        this.reportGeo = reportGeo;
        this.autoarchived = autoarchived;
        this.inviteMembers = inviteMembers;
        this.requestChatBroadcast = requestChatBroadcast;
        this.geoDistance = geoDistance;
        this.requestChatTitle = requestChatTitle;
        this.requestChatDate = requestChatDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PeerSettings.super.identifier();
    }

    private int flagsInitialize() {
        return PeerSettings.super.flags();
    }

    private boolean reportSpamInitialize() {
        return PeerSettings.super.reportSpam();
    }

    private boolean addContactInitialize() {
        return PeerSettings.super.addContact();
    }

    private boolean blockContactInitialize() {
        return PeerSettings.super.blockContact();
    }

    private boolean shareContactInitialize() {
        return PeerSettings.super.shareContact();
    }

    private boolean needContactsExceptionInitialize() {
        return PeerSettings.super.needContactsException();
    }

    private boolean reportGeoInitialize() {
        return PeerSettings.super.reportGeo();
    }

    private boolean autoarchivedInitialize() {
        return PeerSettings.super.autoarchived();
    }

    private boolean inviteMembersInitialize() {
        return PeerSettings.super.inviteMembers();
    }

    private boolean requestChatBroadcastInitialize() {
        return PeerSettings.super.requestChatBroadcast();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean reportSpam() {
        InitShim shim = this.initShim;
        return shim != null ? shim.reportSpam() : this.reportSpam;
    }

    @Override
    public boolean addContact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.addContact() : this.addContact;
    }

    @Override
    public boolean blockContact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.blockContact() : this.blockContact;
    }

    @Override
    public boolean shareContact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shareContact() : this.shareContact;
    }

    @Override
    public boolean needContactsException() {
        InitShim shim = this.initShim;
        return shim != null ? shim.needContactsException() : this.needContactsException;
    }

    @Override
    public boolean reportGeo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.reportGeo() : this.reportGeo;
    }

    @Override
    public boolean autoarchived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.autoarchived() : this.autoarchived;
    }

    @Override
    public boolean inviteMembers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inviteMembers() : this.inviteMembers;
    }

    @Override
    public boolean requestChatBroadcast() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestChatBroadcast() : this.requestChatBroadcast;
    }

    @Override
    @Nullable
    public Integer geoDistance() {
        return this.geoDistance;
    }

    @Override
    @Nullable
    public String requestChatTitle() {
        return this.requestChatTitle;
    }

    @Override
    @Nullable
    public Integer requestChatDate() {
        return this.requestChatDate;
    }

    public final ImmutablePeerSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(value, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, value, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withReportSpam(boolean value) {
        if (this.reportSpam == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, value, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withAddContact(boolean value) {
        if (this.addContact == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, value, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withBlockContact(boolean value) {
        if (this.blockContact == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, value, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withShareContact(boolean value) {
        if (this.shareContact == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, value, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withNeedContactsException(boolean value) {
        if (this.needContactsException == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, value, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withReportGeo(boolean value) {
        if (this.reportGeo == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, value, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withAutoarchived(boolean value) {
        if (this.autoarchived == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, value, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withInviteMembers(boolean value) {
        if (this.inviteMembers == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, value, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withRequestChatBroadcast(boolean value) {
        if (this.requestChatBroadcast == value) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, value, this.geoDistance, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withGeoDistance(@Nullable Integer value) {
        if (Objects.equals(this.geoDistance, value)) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, value, this.requestChatTitle, this.requestChatDate));
    }

    public final ImmutablePeerSettings withRequestChatTitle(@Nullable String value) {
        if (Objects.equals(this.requestChatTitle, value)) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, value, this.requestChatDate));
    }

    public final ImmutablePeerSettings withRequestChatDate(@Nullable Integer value) {
        if (Objects.equals(this.requestChatDate, value)) {
            return this;
        }
        return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this.identifier, this.flags, this.reportSpam, this.addContact, this.blockContact, this.shareContact, this.needContactsException, this.reportGeo, this.autoarchived, this.inviteMembers, this.requestChatBroadcast, this.geoDistance, this.requestChatTitle, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePeerSettings && this.equalTo(0, (ImmutablePeerSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutablePeerSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.reportSpam == another.reportSpam && this.addContact == another.addContact && this.blockContact == another.blockContact && this.shareContact == another.shareContact && this.needContactsException == another.needContactsException && this.reportGeo == another.reportGeo && this.autoarchived == another.autoarchived && this.inviteMembers == another.inviteMembers && this.requestChatBroadcast == another.requestChatBroadcast && Objects.equals(this.geoDistance, another.geoDistance) && Objects.equals(this.requestChatTitle, another.requestChatTitle) && Objects.equals(this.requestChatDate, another.requestChatDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.reportSpam);
        h += (h << 5) + Boolean.hashCode(this.addContact);
        h += (h << 5) + Boolean.hashCode(this.blockContact);
        h += (h << 5) + Boolean.hashCode(this.shareContact);
        h += (h << 5) + Boolean.hashCode(this.needContactsException);
        h += (h << 5) + Boolean.hashCode(this.reportGeo);
        h += (h << 5) + Boolean.hashCode(this.autoarchived);
        h += (h << 5) + Boolean.hashCode(this.inviteMembers);
        h += (h << 5) + Boolean.hashCode(this.requestChatBroadcast);
        h += (h << 5) + Objects.hashCode(this.geoDistance);
        h += (h << 5) + Objects.hashCode(this.requestChatTitle);
        h += (h << 5) + Objects.hashCode(this.requestChatDate);
        return h;
    }

    public String toString() {
        return "PeerSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", reportSpam=" + this.reportSpam + ", addContact=" + this.addContact + ", blockContact=" + this.blockContact + ", shareContact=" + this.shareContact + ", needContactsException=" + this.needContactsException + ", reportGeo=" + this.reportGeo + ", autoarchived=" + this.autoarchived + ", inviteMembers=" + this.inviteMembers + ", requestChatBroadcast=" + this.requestChatBroadcast + ", geoDistance=" + this.geoDistance + ", requestChatTitle=" + this.requestChatTitle + ", requestChatDate=" + this.requestChatDate + "}";
    }

    public static ImmutablePeerSettings of() {
        return INSTANCE;
    }

    private static ImmutablePeerSettings validate(ImmutablePeerSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePeerSettings copyOf(PeerSettings instance) {
        if (instance instanceof ImmutablePeerSettings) {
            return (ImmutablePeerSettings)instance;
        }
        return ImmutablePeerSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REPORT_SPAM = 4L;
        private static final long OPT_BIT_ADD_CONTACT = 8L;
        private static final long OPT_BIT_BLOCK_CONTACT = 16L;
        private static final long OPT_BIT_SHARE_CONTACT = 32L;
        private static final long OPT_BIT_NEED_CONTACTS_EXCEPTION = 64L;
        private static final long OPT_BIT_REPORT_GEO = 128L;
        private static final long OPT_BIT_AUTOARCHIVED = 256L;
        private static final long OPT_BIT_INVITE_MEMBERS = 512L;
        private static final long OPT_BIT_REQUEST_CHAT_BROADCAST = 1024L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean reportSpam;
        private boolean addContact;
        private boolean blockContact;
        private boolean shareContact;
        private boolean needContactsException;
        private boolean reportGeo;
        private boolean autoarchived;
        private boolean inviteMembers;
        private boolean requestChatBroadcast;
        private Integer geoDistance;
        private String requestChatTitle;
        private Integer requestChatDate;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PeerSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PeerSettings) {
                instance = (PeerSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reportSpam(instance.reportSpam());
                Integer requestChatDateValue = instance.requestChatDate();
                if (requestChatDateValue != null) {
                    this.requestChatDate(requestChatDateValue);
                }
                this.flags(instance.flags());
                this.shareContact(instance.shareContact());
                this.blockContact(instance.blockContact());
                this.autoarchived(instance.autoarchived());
                this.addContact(instance.addContact());
                this.inviteMembers(instance.inviteMembers());
                this.reportGeo(instance.reportGeo());
                Integer geoDistanceValue = instance.geoDistance();
                if (geoDistanceValue != null) {
                    this.geoDistance(geoDistanceValue);
                }
                this.needContactsException(instance.needContactsException());
                String requestChatTitleValue = instance.requestChatTitle();
                if (requestChatTitleValue != null) {
                    this.requestChatTitle(requestChatTitleValue);
                }
                this.requestChatBroadcast(instance.requestChatBroadcast());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder reportSpam(boolean reportSpam) {
            this.reportSpam = reportSpam;
            this.optBits |= 4L;
            return this;
        }

        public final Builder addContact(boolean addContact) {
            this.addContact = addContact;
            this.optBits |= 8L;
            return this;
        }

        public final Builder blockContact(boolean blockContact) {
            this.blockContact = blockContact;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder shareContact(boolean shareContact) {
            this.shareContact = shareContact;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder needContactsException(boolean needContactsException) {
            this.needContactsException = needContactsException;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder reportGeo(boolean reportGeo) {
            this.reportGeo = reportGeo;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder autoarchived(boolean autoarchived) {
            this.autoarchived = autoarchived;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder inviteMembers(boolean inviteMembers) {
            this.inviteMembers = inviteMembers;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder requestChatBroadcast(boolean requestChatBroadcast) {
            this.requestChatBroadcast = requestChatBroadcast;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder geoDistance(@Nullable Integer geoDistance) {
            this.geoDistance = geoDistance;
            return this;
        }

        public final Builder requestChatTitle(@Nullable String requestChatTitle) {
            this.requestChatTitle = requestChatTitle;
            return this;
        }

        public final Builder requestChatDate(@Nullable Integer requestChatDate) {
            this.requestChatDate = requestChatDate;
            return this;
        }

        public ImmutablePeerSettings build() {
            return ImmutablePeerSettings.validate(new ImmutablePeerSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean reportSpamIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean addContactIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean blockContactIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean shareContactIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean needContactsExceptionIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean reportGeoIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean autoarchivedIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean inviteMembersIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean requestChatBroadcastIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte reportSpamBuildStage = 0;
        private boolean reportSpam;
        private byte addContactBuildStage = 0;
        private boolean addContact;
        private byte blockContactBuildStage = 0;
        private boolean blockContact;
        private byte shareContactBuildStage = 0;
        private boolean shareContact;
        private byte needContactsExceptionBuildStage = 0;
        private boolean needContactsException;
        private byte reportGeoBuildStage = 0;
        private boolean reportGeo;
        private byte autoarchivedBuildStage = 0;
        private boolean autoarchived;
        private byte inviteMembersBuildStage = 0;
        private boolean inviteMembers;
        private byte requestChatBroadcastBuildStage = 0;
        private boolean requestChatBroadcast;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePeerSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePeerSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean reportSpam() {
            if (this.reportSpamBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reportSpamBuildStage == 0) {
                this.reportSpamBuildStage = (byte)-1;
                this.reportSpam = ImmutablePeerSettings.this.reportSpamInitialize();
                this.reportSpamBuildStage = 1;
            }
            return this.reportSpam;
        }

        void reportSpam(boolean reportSpam) {
            this.reportSpam = reportSpam;
            this.reportSpamBuildStage = 1;
        }

        boolean addContact() {
            if (this.addContactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addContactBuildStage == 0) {
                this.addContactBuildStage = (byte)-1;
                this.addContact = ImmutablePeerSettings.this.addContactInitialize();
                this.addContactBuildStage = 1;
            }
            return this.addContact;
        }

        void addContact(boolean addContact) {
            this.addContact = addContact;
            this.addContactBuildStage = 1;
        }

        boolean blockContact() {
            if (this.blockContactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.blockContactBuildStage == 0) {
                this.blockContactBuildStage = (byte)-1;
                this.blockContact = ImmutablePeerSettings.this.blockContactInitialize();
                this.blockContactBuildStage = 1;
            }
            return this.blockContact;
        }

        void blockContact(boolean blockContact) {
            this.blockContact = blockContact;
            this.blockContactBuildStage = 1;
        }

        boolean shareContact() {
            if (this.shareContactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shareContactBuildStage == 0) {
                this.shareContactBuildStage = (byte)-1;
                this.shareContact = ImmutablePeerSettings.this.shareContactInitialize();
                this.shareContactBuildStage = 1;
            }
            return this.shareContact;
        }

        void shareContact(boolean shareContact) {
            this.shareContact = shareContact;
            this.shareContactBuildStage = 1;
        }

        boolean needContactsException() {
            if (this.needContactsExceptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.needContactsExceptionBuildStage == 0) {
                this.needContactsExceptionBuildStage = (byte)-1;
                this.needContactsException = ImmutablePeerSettings.this.needContactsExceptionInitialize();
                this.needContactsExceptionBuildStage = 1;
            }
            return this.needContactsException;
        }

        void needContactsException(boolean needContactsException) {
            this.needContactsException = needContactsException;
            this.needContactsExceptionBuildStage = 1;
        }

        boolean reportGeo() {
            if (this.reportGeoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reportGeoBuildStage == 0) {
                this.reportGeoBuildStage = (byte)-1;
                this.reportGeo = ImmutablePeerSettings.this.reportGeoInitialize();
                this.reportGeoBuildStage = 1;
            }
            return this.reportGeo;
        }

        void reportGeo(boolean reportGeo) {
            this.reportGeo = reportGeo;
            this.reportGeoBuildStage = 1;
        }

        boolean autoarchived() {
            if (this.autoarchivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.autoarchivedBuildStage == 0) {
                this.autoarchivedBuildStage = (byte)-1;
                this.autoarchived = ImmutablePeerSettings.this.autoarchivedInitialize();
                this.autoarchivedBuildStage = 1;
            }
            return this.autoarchived;
        }

        void autoarchived(boolean autoarchived) {
            this.autoarchived = autoarchived;
            this.autoarchivedBuildStage = 1;
        }

        boolean inviteMembers() {
            if (this.inviteMembersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inviteMembersBuildStage == 0) {
                this.inviteMembersBuildStage = (byte)-1;
                this.inviteMembers = ImmutablePeerSettings.this.inviteMembersInitialize();
                this.inviteMembersBuildStage = 1;
            }
            return this.inviteMembers;
        }

        void inviteMembers(boolean inviteMembers) {
            this.inviteMembers = inviteMembers;
            this.inviteMembersBuildStage = 1;
        }

        boolean requestChatBroadcast() {
            if (this.requestChatBroadcastBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestChatBroadcastBuildStage == 0) {
                this.requestChatBroadcastBuildStage = (byte)-1;
                this.requestChatBroadcast = ImmutablePeerSettings.this.requestChatBroadcastInitialize();
                this.requestChatBroadcastBuildStage = 1;
            }
            return this.requestChatBroadcast;
        }

        void requestChatBroadcast(boolean requestChatBroadcast) {
            this.requestChatBroadcast = requestChatBroadcast;
            this.requestChatBroadcastBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.reportSpamBuildStage == -1) {
                attributes.add("reportSpam");
            }
            if (this.addContactBuildStage == -1) {
                attributes.add("addContact");
            }
            if (this.blockContactBuildStage == -1) {
                attributes.add("blockContact");
            }
            if (this.shareContactBuildStage == -1) {
                attributes.add("shareContact");
            }
            if (this.needContactsExceptionBuildStage == -1) {
                attributes.add("needContactsException");
            }
            if (this.reportGeoBuildStage == -1) {
                attributes.add("reportGeo");
            }
            if (this.autoarchivedBuildStage == -1) {
                attributes.add("autoarchived");
            }
            if (this.inviteMembersBuildStage == -1) {
                attributes.add("inviteMembers");
            }
            if (this.requestChatBroadcastBuildStage == -1) {
                attributes.add("requestChatBroadcast");
            }
            return "Cannot build PeerSettings, attribute initializers form cycle " + attributes;
        }
    }
}

