/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerUser;
import telegram4j.tl.api.TlObject;

public final class ImmutablePeerUser
implements PeerUser {
    private final int identifier;
    private final long userId;

    private ImmutablePeerUser(long userId) {
        this.userId = userId;
        this.identifier = PeerUser.super.identifier();
    }

    private ImmutablePeerUser(Builder builder) {
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PeerUser.super.identifier();
    }

    private ImmutablePeerUser(int identifier, long userId) {
        this.identifier = identifier;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    public final ImmutablePeerUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePeerUser(value, this.userId);
    }

    public final ImmutablePeerUser withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutablePeerUser(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePeerUser && this.equalTo(0, (ImmutablePeerUser)another);
    }

    private boolean equalTo(int synthetic, ImmutablePeerUser another) {
        return this.identifier == another.identifier && this.userId == another.userId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "PeerUser{identifier=" + this.identifier + ", userId=" + this.userId + "}";
    }

    public static ImmutablePeerUser of(long userId) {
        return new ImmutablePeerUser(userId);
    }

    public static ImmutablePeerUser copyOf(PeerUser instance) {
        if (instance instanceof ImmutablePeerUser) {
            return (ImmutablePeerUser)instance;
        }
        return ImmutablePeerUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long userId;

        private Builder() {
        }

        public final Builder from(Peer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PeerUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Peer instance;
            long bits = 0L;
            if (object instanceof Peer) {
                instance = (Peer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PeerUser) {
                instance = (PeerUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePeerUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePeerUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build PeerUser, some of required attributes are not set " + attributes;
        }
    }
}

