/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PhoneCall;
import telegram4j.tl.PhoneCallDiscardReason;
import telegram4j.tl.PhoneCallDiscarded;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhoneCallDiscarded
implements PhoneCallDiscarded {
    private final int identifier;
    private final int flags;
    private final boolean needRating;
    private final boolean needDebug;
    private final boolean video;
    private final long id;
    @Nullable
    private final PhoneCallDiscardReason reason;
    @Nullable
    private final Integer duration;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhoneCallDiscarded(long id) {
        this.id = id;
        this.reason = null;
        this.duration = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.needRating = this.initShim.needRating();
        this.needDebug = this.initShim.needDebug();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutablePhoneCallDiscarded(Builder builder) {
        this.id = builder.id;
        this.reason = builder.reason;
        this.duration = builder.duration;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.needRatingIsSet()) {
            this.initShim.needRating(builder.needRating);
        }
        if (builder.needDebugIsSet()) {
            this.initShim.needDebug(builder.needDebug);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.needRating = this.initShim.needRating();
        this.needDebug = this.initShim.needDebug();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutablePhoneCallDiscarded(int identifier, int flags, boolean needRating, boolean needDebug, boolean video, long id, @Nullable PhoneCallDiscardReason reason, @Nullable Integer duration) {
        this.identifier = identifier;
        this.flags = flags;
        this.needRating = needRating;
        this.needDebug = needDebug;
        this.video = video;
        this.id = id;
        this.reason = reason;
        this.duration = duration;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhoneCallDiscarded.super.identifier();
    }

    private int flagsInitialize() {
        return PhoneCallDiscarded.super.flags();
    }

    private boolean needRatingInitialize() {
        return PhoneCallDiscarded.super.needRating();
    }

    private boolean needDebugInitialize() {
        return PhoneCallDiscarded.super.needDebug();
    }

    private boolean videoInitialize() {
        return PhoneCallDiscarded.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean needRating() {
        InitShim shim = this.initShim;
        return shim != null ? shim.needRating() : this.needRating;
    }

    @Override
    public boolean needDebug() {
        InitShim shim = this.initShim;
        return shim != null ? shim.needDebug() : this.needDebug;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    @Nullable
    public PhoneCallDiscardReason reason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Integer duration() {
        return this.duration;
    }

    public final ImmutablePhoneCallDiscarded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(value, this.flags, this.needRating, this.needDebug, this.video, this.id, this.reason, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, value, this.needRating, this.needDebug, this.video, this.id, this.reason, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withNeedRating(boolean value) {
        if (this.needRating == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, this.flags, value, this.needDebug, this.video, this.id, this.reason, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withNeedDebug(boolean value) {
        if (this.needDebug == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, this.flags, this.needRating, value, this.video, this.id, this.reason, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, this.flags, this.needRating, this.needDebug, value, this.id, this.reason, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, this.flags, this.needRating, this.needDebug, this.video, value, this.reason, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withReason(@Nullable PhoneCallDiscardReason value) {
        if (this.reason == value) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, this.flags, this.needRating, this.needDebug, this.video, this.id, value, this.duration);
    }

    public final ImmutablePhoneCallDiscarded withDuration(@Nullable Integer value) {
        if (Objects.equals(this.duration, value)) {
            return this;
        }
        return new ImmutablePhoneCallDiscarded(this.identifier, this.flags, this.needRating, this.needDebug, this.video, this.id, this.reason, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoneCallDiscarded && this.equalTo(0, (ImmutablePhoneCallDiscarded)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoneCallDiscarded another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.needRating == another.needRating && this.needDebug == another.needDebug && this.video == another.video && this.id == another.id && Objects.equals((Object)this.reason, (Object)another.reason) && Objects.equals(this.duration, another.duration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.needRating);
        h += (h << 5) + Boolean.hashCode(this.needDebug);
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Objects.hashCode((Object)this.reason);
        h += (h << 5) + Objects.hashCode(this.duration);
        return h;
    }

    public String toString() {
        return "PhoneCallDiscarded{identifier=" + this.identifier + ", flags=" + this.flags + ", needRating=" + this.needRating + ", needDebug=" + this.needDebug + ", video=" + this.video + ", id=" + this.id + ", reason=" + this.reason + ", duration=" + this.duration + "}";
    }

    public static ImmutablePhoneCallDiscarded of(long id) {
        return new ImmutablePhoneCallDiscarded(id);
    }

    public static ImmutablePhoneCallDiscarded copyOf(PhoneCallDiscarded instance) {
        if (instance instanceof ImmutablePhoneCallDiscarded) {
            return (ImmutablePhoneCallDiscarded)instance;
        }
        return ImmutablePhoneCallDiscarded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NEED_RATING = 4L;
        private static final long OPT_BIT_NEED_DEBUG = 8L;
        private static final long OPT_BIT_VIDEO = 16L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean needRating;
        private boolean needDebug;
        private boolean video;
        private long id;
        private PhoneCallDiscardReason reason;
        private Integer duration;

        private Builder() {
        }

        public final Builder from(PhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhoneCallDiscarded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneCall instance;
            long bits = 0L;
            if (object instanceof PhoneCall) {
                instance = (PhoneCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof PhoneCallDiscarded) {
                PhoneCallDiscardReason reasonValue;
                instance = (PhoneCallDiscarded)object;
                Integer durationValue = instance.duration();
                if (durationValue != null) {
                    this.duration(durationValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((reasonValue = instance.reason()) != null) {
                    this.reason(reasonValue);
                }
                this.flags(instance.flags());
                this.needDebug(instance.needDebug());
                this.video(instance.video());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.needRating(instance.needRating());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder needRating(boolean needRating) {
            this.needRating = needRating;
            this.optBits |= 4L;
            return this;
        }

        public final Builder needDebug(boolean needDebug) {
            this.needDebug = needDebug;
            this.optBits |= 8L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reason(@Nullable PhoneCallDiscardReason reason) {
            this.reason = reason;
            return this;
        }

        public final Builder duration(@Nullable Integer duration) {
            this.duration = duration;
            return this;
        }

        public ImmutablePhoneCallDiscarded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoneCallDiscarded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean needRatingIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean needDebugIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build PhoneCallDiscarded, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte needRatingBuildStage = 0;
        private boolean needRating;
        private byte needDebugBuildStage = 0;
        private boolean needDebug;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhoneCallDiscarded.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePhoneCallDiscarded.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean needRating() {
            if (this.needRatingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.needRatingBuildStage == 0) {
                this.needRatingBuildStage = (byte)-1;
                this.needRating = ImmutablePhoneCallDiscarded.this.needRatingInitialize();
                this.needRatingBuildStage = 1;
            }
            return this.needRating;
        }

        void needRating(boolean needRating) {
            this.needRating = needRating;
            this.needRatingBuildStage = 1;
        }

        boolean needDebug() {
            if (this.needDebugBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.needDebugBuildStage == 0) {
                this.needDebugBuildStage = (byte)-1;
                this.needDebug = ImmutablePhoneCallDiscarded.this.needDebugInitialize();
                this.needDebugBuildStage = 1;
            }
            return this.needDebug;
        }

        void needDebug(boolean needDebug) {
            this.needDebug = needDebug;
            this.needDebugBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutablePhoneCallDiscarded.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.needRatingBuildStage == -1) {
                attributes.add("needRating");
            }
            if (this.needDebugBuildStage == -1) {
                attributes.add("needDebug");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build PhoneCallDiscarded, attribute initializers form cycle " + attributes;
        }
    }
}

