/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhoneCallProtocol
implements PhoneCallProtocol {
    private final int identifier;
    private final int flags;
    private final boolean udpP2p;
    private final boolean udpReflector;
    private final int minLayer;
    private final int maxLayer;
    private final List<String> libraryVersions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhoneCallProtocol(int minLayer, int maxLayer) {
        this.minLayer = minLayer;
        this.maxLayer = maxLayer;
        this.libraryVersions = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.udpP2p = this.initShim.udpP2p();
        this.udpReflector = this.initShim.udpReflector();
        this.initShim = null;
    }

    private ImmutablePhoneCallProtocol(Builder builder) {
        this.minLayer = builder.minLayer;
        this.maxLayer = builder.maxLayer;
        this.libraryVersions = ImmutablePhoneCallProtocol.createUnmodifiableList(true, builder.libraryVersions);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.udpP2pIsSet()) {
            this.initShim.udpP2p(builder.udpP2p);
        }
        if (builder.udpReflectorIsSet()) {
            this.initShim.udpReflector(builder.udpReflector);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.udpP2p = this.initShim.udpP2p();
        this.udpReflector = this.initShim.udpReflector();
        this.initShim = null;
    }

    private ImmutablePhoneCallProtocol(int identifier, int flags, boolean udpP2p, boolean udpReflector, int minLayer, int maxLayer, List<String> libraryVersions) {
        this.identifier = identifier;
        this.flags = flags;
        this.udpP2p = udpP2p;
        this.udpReflector = udpReflector;
        this.minLayer = minLayer;
        this.maxLayer = maxLayer;
        this.libraryVersions = libraryVersions;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhoneCallProtocol.super.identifier();
    }

    private int flagsInitialize() {
        return PhoneCallProtocol.super.flags();
    }

    private boolean udpP2pInitialize() {
        return PhoneCallProtocol.super.udpP2p();
    }

    private boolean udpReflectorInitialize() {
        return PhoneCallProtocol.super.udpReflector();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean udpP2p() {
        InitShim shim = this.initShim;
        return shim != null ? shim.udpP2p() : this.udpP2p;
    }

    @Override
    public boolean udpReflector() {
        InitShim shim = this.initShim;
        return shim != null ? shim.udpReflector() : this.udpReflector;
    }

    @Override
    public int minLayer() {
        return this.minLayer;
    }

    @Override
    public int maxLayer() {
        return this.maxLayer;
    }

    @Override
    public List<String> libraryVersions() {
        return this.libraryVersions;
    }

    public final ImmutablePhoneCallProtocol withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoneCallProtocol(value, this.flags, this.udpP2p, this.udpReflector, this.minLayer, this.maxLayer, this.libraryVersions);
    }

    public final ImmutablePhoneCallProtocol withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePhoneCallProtocol(this.identifier, value, this.udpP2p, this.udpReflector, this.minLayer, this.maxLayer, this.libraryVersions);
    }

    public final ImmutablePhoneCallProtocol withUdpP2p(boolean value) {
        if (this.udpP2p == value) {
            return this;
        }
        return new ImmutablePhoneCallProtocol(this.identifier, this.flags, value, this.udpReflector, this.minLayer, this.maxLayer, this.libraryVersions);
    }

    public final ImmutablePhoneCallProtocol withUdpReflector(boolean value) {
        if (this.udpReflector == value) {
            return this;
        }
        return new ImmutablePhoneCallProtocol(this.identifier, this.flags, this.udpP2p, value, this.minLayer, this.maxLayer, this.libraryVersions);
    }

    public final ImmutablePhoneCallProtocol withMinLayer(int value) {
        if (this.minLayer == value) {
            return this;
        }
        return new ImmutablePhoneCallProtocol(this.identifier, this.flags, this.udpP2p, this.udpReflector, value, this.maxLayer, this.libraryVersions);
    }

    public final ImmutablePhoneCallProtocol withMaxLayer(int value) {
        if (this.maxLayer == value) {
            return this;
        }
        return new ImmutablePhoneCallProtocol(this.identifier, this.flags, this.udpP2p, this.udpReflector, this.minLayer, value, this.libraryVersions);
    }

    public final ImmutablePhoneCallProtocol withLibraryVersions(String ... elements) {
        List<String> newValue = ImmutablePhoneCallProtocol.createUnmodifiableList(false, ImmutablePhoneCallProtocol.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePhoneCallProtocol(this.identifier, this.flags, this.udpP2p, this.udpReflector, this.minLayer, this.maxLayer, newValue);
    }

    public final ImmutablePhoneCallProtocol withLibraryVersions(Iterable<String> elements) {
        if (this.libraryVersions == elements) {
            return this;
        }
        List<String> newValue = ImmutablePhoneCallProtocol.createUnmodifiableList(false, ImmutablePhoneCallProtocol.createSafeList(elements, true, false));
        return new ImmutablePhoneCallProtocol(this.identifier, this.flags, this.udpP2p, this.udpReflector, this.minLayer, this.maxLayer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoneCallProtocol && this.equalTo(0, (ImmutablePhoneCallProtocol)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoneCallProtocol another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.udpP2p == another.udpP2p && this.udpReflector == another.udpReflector && this.minLayer == another.minLayer && this.maxLayer == another.maxLayer && this.libraryVersions.equals(another.libraryVersions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.udpP2p);
        h += (h << 5) + Boolean.hashCode(this.udpReflector);
        h += (h << 5) + this.minLayer;
        h += (h << 5) + this.maxLayer;
        h += (h << 5) + this.libraryVersions.hashCode();
        return h;
    }

    public String toString() {
        return "PhoneCallProtocol{identifier=" + this.identifier + ", flags=" + this.flags + ", udpP2p=" + this.udpP2p + ", udpReflector=" + this.udpReflector + ", minLayer=" + this.minLayer + ", maxLayer=" + this.maxLayer + ", libraryVersions=" + this.libraryVersions + "}";
    }

    public static ImmutablePhoneCallProtocol of(int minLayer, int maxLayer) {
        return new ImmutablePhoneCallProtocol(minLayer, maxLayer);
    }

    public static ImmutablePhoneCallProtocol copyOf(PhoneCallProtocol instance) {
        if (instance instanceof ImmutablePhoneCallProtocol) {
            return (ImmutablePhoneCallProtocol)instance;
        }
        return ImmutablePhoneCallProtocol.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MIN_LAYER = 1L;
        private static final long INIT_BIT_MAX_LAYER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_UDP_P2P = 4L;
        private static final long OPT_BIT_UDP_REFLECTOR = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean udpP2p;
        private boolean udpReflector;
        private int minLayer;
        private int maxLayer;
        private List<String> libraryVersions = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PhoneCallProtocol instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneCallProtocol instance;
            long bits = 0L;
            if (object instanceof PhoneCallProtocol) {
                instance = (PhoneCallProtocol)object;
                this.udpReflector(instance.udpReflector());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.udpP2p(instance.udpP2p());
                this.maxLayer(instance.maxLayer());
                this.flags(instance.flags());
                this.addAllLibraryVersions(instance.libraryVersions());
                this.minLayer(instance.minLayer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder udpP2p(boolean udpP2p) {
            this.udpP2p = udpP2p;
            this.optBits |= 4L;
            return this;
        }

        public final Builder udpReflector(boolean udpReflector) {
            this.udpReflector = udpReflector;
            this.optBits |= 8L;
            return this;
        }

        public final Builder minLayer(int minLayer) {
            this.minLayer = minLayer;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxLayer(int maxLayer) {
            this.maxLayer = maxLayer;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addLibraryVersion(String element) {
            this.libraryVersions.add(Objects.requireNonNull(element, "libraryVersions element"));
            return this;
        }

        public final Builder addLibraryVersions(String ... elements) {
            for (String element : elements) {
                this.libraryVersions.add(Objects.requireNonNull(element, "libraryVersions element"));
            }
            return this;
        }

        public final Builder libraryVersions(Iterable<String> elements) {
            this.libraryVersions.clear();
            return this.addAllLibraryVersions(elements);
        }

        public final Builder addAllLibraryVersions(Iterable<String> elements) {
            for (String element : elements) {
                this.libraryVersions.add(Objects.requireNonNull(element, "libraryVersions element"));
            }
            return this;
        }

        public ImmutablePhoneCallProtocol build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoneCallProtocol(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean udpP2pIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean udpReflectorIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("minLayer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxLayer");
            }
            return "Cannot build PhoneCallProtocol, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte udpP2pBuildStage = 0;
        private boolean udpP2p;
        private byte udpReflectorBuildStage = 0;
        private boolean udpReflector;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhoneCallProtocol.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePhoneCallProtocol.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean udpP2p() {
            if (this.udpP2pBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.udpP2pBuildStage == 0) {
                this.udpP2pBuildStage = (byte)-1;
                this.udpP2p = ImmutablePhoneCallProtocol.this.udpP2pInitialize();
                this.udpP2pBuildStage = 1;
            }
            return this.udpP2p;
        }

        void udpP2p(boolean udpP2p) {
            this.udpP2p = udpP2p;
            this.udpP2pBuildStage = 1;
        }

        boolean udpReflector() {
            if (this.udpReflectorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.udpReflectorBuildStage == 0) {
                this.udpReflectorBuildStage = (byte)-1;
                this.udpReflector = ImmutablePhoneCallProtocol.this.udpReflectorInitialize();
                this.udpReflectorBuildStage = 1;
            }
            return this.udpReflector;
        }

        void udpReflector(boolean udpReflector) {
            this.udpReflector = udpReflector;
            this.udpReflectorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.udpP2pBuildStage == -1) {
                attributes.add("udpP2p");
            }
            if (this.udpReflectorBuildStage == -1) {
                attributes.add("udpReflector");
            }
            return "Cannot build PhoneCallProtocol, attribute initializers form cycle " + attributes;
        }
    }
}

