/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PhoneCall;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.PhoneCallRequested;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhoneCallRequested
implements PhoneCallRequested {
    private final int identifier;
    private final int flags;
    private final boolean video;
    private final long id;
    private final long accessHash;
    private final int date;
    private final long adminId;
    private final long participantId;
    private final ByteBuf gAHash;
    private final PhoneCallProtocol protocol;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhoneCallRequested(long id, long accessHash, int date, long adminId, long participantId, PhoneCallProtocol protocol) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.gAHash = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutablePhoneCallRequested(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.date = builder.date;
        this.adminId = builder.adminId;
        this.participantId = builder.participantId;
        this.gAHash = builder.gAHash_build();
        this.protocol = builder.protocol;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutablePhoneCallRequested(int identifier, int flags, boolean video, long id, long accessHash, int date, long adminId, long participantId, ByteBuf gAHash, PhoneCallProtocol protocol) {
        this.identifier = identifier;
        this.flags = flags;
        this.video = video;
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.gAHash = gAHash;
        this.protocol = protocol;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhoneCallRequested.super.identifier();
    }

    private int flagsInitialize() {
        return PhoneCallRequested.super.flags();
    }

    private boolean videoInitialize() {
        return PhoneCallRequested.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public long participantId() {
        return this.participantId;
    }

    @Override
    public ByteBuf gAHash() {
        return this.gAHash.duplicate();
    }

    @Override
    public PhoneCallProtocol protocol() {
        return this.protocol;
    }

    public final ImmutablePhoneCallRequested withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(value, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, value, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, value, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, value, this.accessHash, this.date, this.adminId, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, this.id, value, this.date, this.adminId, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, this.id, this.accessHash, value, this.adminId, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, value, this.participantId, this.gAHash, this.protocol);
    }

    public final ImmutablePhoneCallRequested withParticipantId(long value) {
        if (this.participantId == value) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, value, this.gAHash, this.protocol);
    }

    public ImmutablePhoneCallRequested withGAHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gAHash == newValue) {
            return this;
        }
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, newValue, this.protocol);
    }

    public final ImmutablePhoneCallRequested withProtocol(PhoneCallProtocol value) {
        if (this.protocol == value) {
            return this;
        }
        PhoneCallProtocol newValue = Objects.requireNonNull(value, "protocol");
        return new ImmutablePhoneCallRequested(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoneCallRequested && this.equalTo(0, (ImmutablePhoneCallRequested)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoneCallRequested another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.video == another.video && this.id == another.id && this.accessHash == another.accessHash && this.date == another.date && this.adminId == another.adminId && this.participantId == another.participantId && this.gAHash().equals((Object)another.gAHash()) && this.protocol.equals(another.protocol);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + Long.hashCode(this.participantId);
        h += (h << 5) + this.gAHash().hashCode();
        h += (h << 5) + this.protocol.hashCode();
        return h;
    }

    public String toString() {
        return "PhoneCallRequested{identifier=" + this.identifier + ", flags=" + this.flags + ", video=" + this.video + ", id=" + this.id + ", accessHash=" + this.accessHash + ", date=" + this.date + ", adminId=" + this.adminId + ", participantId=" + this.participantId + ", gAHash=" + ByteBufUtil.hexDump((ByteBuf)this.gAHash) + ", protocol=" + this.protocol + "}";
    }

    public static ImmutablePhoneCallRequested of(long id, long accessHash, int date, long adminId, long participantId, PhoneCallProtocol protocol) {
        return new ImmutablePhoneCallRequested(id, accessHash, date, adminId, participantId, protocol);
    }

    public static ImmutablePhoneCallRequested copyOf(PhoneCallRequested instance) {
        if (instance instanceof ImmutablePhoneCallRequested) {
            return (ImmutablePhoneCallRequested)instance;
        }
        return ImmutablePhoneCallRequested.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_ID = 8L;
        private static final long INIT_BIT_PARTICIPANT_ID = 16L;
        private static final long INIT_BIT_PROTOCOL = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VIDEO = 4L;
        private long initBits = 63L;
        private long optBits;
        private ByteBuf gAHash_value = null;
        private int identifier;
        private int flags;
        private boolean video;
        private long id;
        private long accessHash;
        private int date;
        private long adminId;
        private long participantId;
        private PhoneCallProtocol protocol;

        private Builder() {
        }

        public final Builder from(PhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhoneCallRequested instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneCall instance;
            long bits = 0L;
            if (object instanceof PhoneCall) {
                instance = (PhoneCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof PhoneCallRequested) {
                instance = (PhoneCallRequested)object;
                this.date(instance.date());
                this.participantId(instance.participantId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.gAHash(instance.gAHash());
                this.protocol(instance.protocol());
                this.flags(instance.flags());
                this.adminId(instance.adminId());
                this.accessHash(instance.accessHash());
                this.video(instance.video());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder participantId(long participantId) {
            this.participantId = participantId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder gAHash(ByteBuf value) {
            this.gAHash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder protocol(PhoneCallProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePhoneCallRequested build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoneCallRequested(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("participantId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("protocol");
            }
            return "Cannot build PhoneCallRequested, some of required attributes are not set " + attributes;
        }

        private ByteBuf gAHash_build() {
            return Objects.requireNonNull(this.gAHash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhoneCallRequested.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePhoneCallRequested.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutablePhoneCallRequested.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build PhoneCallRequested, attribute initializers form cycle " + attributes;
        }
    }
}

