/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PhoneCall;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.PhoneCallWaiting;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhoneCallWaiting
implements PhoneCallWaiting {
    private final int identifier;
    private final int flags;
    private final boolean video;
    private final long id;
    private final long accessHash;
    private final int date;
    private final long adminId;
    private final long participantId;
    private final PhoneCallProtocol protocol;
    @Nullable
    private final Integer receiveDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhoneCallWaiting(long id, long accessHash, int date, long adminId, long participantId, PhoneCallProtocol protocol) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.receiveDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutablePhoneCallWaiting(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.date = builder.date;
        this.adminId = builder.adminId;
        this.participantId = builder.participantId;
        this.protocol = builder.protocol;
        this.receiveDate = builder.receiveDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutablePhoneCallWaiting(int identifier, int flags, boolean video, long id, long accessHash, int date, long adminId, long participantId, PhoneCallProtocol protocol, @Nullable Integer receiveDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.video = video;
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.protocol = protocol;
        this.receiveDate = receiveDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhoneCallWaiting.super.identifier();
    }

    private int flagsInitialize() {
        return PhoneCallWaiting.super.flags();
    }

    private boolean videoInitialize() {
        return PhoneCallWaiting.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public long participantId() {
        return this.participantId;
    }

    @Override
    public PhoneCallProtocol protocol() {
        return this.protocol;
    }

    @Override
    @Nullable
    public Integer receiveDate() {
        return this.receiveDate;
    }

    public final ImmutablePhoneCallWaiting withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(value, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, value, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, value, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, value, this.accessHash, this.date, this.adminId, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, this.id, value, this.date, this.adminId, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, this.id, this.accessHash, value, this.adminId, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, value, this.participantId, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withParticipantId(long value) {
        if (this.participantId == value) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, value, this.protocol, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withProtocol(PhoneCallProtocol value) {
        if (this.protocol == value) {
            return this;
        }
        PhoneCallProtocol newValue = Objects.requireNonNull(value, "protocol");
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, newValue, this.receiveDate);
    }

    public final ImmutablePhoneCallWaiting withReceiveDate(@Nullable Integer value) {
        if (Objects.equals(this.receiveDate, value)) {
            return this;
        }
        return new ImmutablePhoneCallWaiting(this.identifier, this.flags, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.protocol, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoneCallWaiting && this.equalTo(0, (ImmutablePhoneCallWaiting)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoneCallWaiting another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.video == another.video && this.id == another.id && this.accessHash == another.accessHash && this.date == another.date && this.adminId == another.adminId && this.participantId == another.participantId && this.protocol.equals(another.protocol) && Objects.equals(this.receiveDate, another.receiveDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + Long.hashCode(this.participantId);
        h += (h << 5) + this.protocol.hashCode();
        h += (h << 5) + Objects.hashCode(this.receiveDate);
        return h;
    }

    public String toString() {
        return "PhoneCallWaiting{identifier=" + this.identifier + ", flags=" + this.flags + ", video=" + this.video + ", id=" + this.id + ", accessHash=" + this.accessHash + ", date=" + this.date + ", adminId=" + this.adminId + ", participantId=" + this.participantId + ", protocol=" + this.protocol + ", receiveDate=" + this.receiveDate + "}";
    }

    public static ImmutablePhoneCallWaiting of(long id, long accessHash, int date, long adminId, long participantId, PhoneCallProtocol protocol) {
        return new ImmutablePhoneCallWaiting(id, accessHash, date, adminId, participantId, protocol);
    }

    public static ImmutablePhoneCallWaiting copyOf(PhoneCallWaiting instance) {
        if (instance instanceof ImmutablePhoneCallWaiting) {
            return (ImmutablePhoneCallWaiting)instance;
        }
        return ImmutablePhoneCallWaiting.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_ID = 8L;
        private static final long INIT_BIT_PARTICIPANT_ID = 16L;
        private static final long INIT_BIT_PROTOCOL = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VIDEO = 4L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean video;
        private long id;
        private long accessHash;
        private int date;
        private long adminId;
        private long participantId;
        private PhoneCallProtocol protocol;
        private Integer receiveDate;

        private Builder() {
        }

        public final Builder from(PhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhoneCallWaiting instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneCall instance;
            long bits = 0L;
            if (object instanceof PhoneCall) {
                instance = (PhoneCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof PhoneCallWaiting) {
                instance = (PhoneCallWaiting)object;
                this.date(instance.date());
                this.participantId(instance.participantId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.protocol(instance.protocol());
                this.flags(instance.flags());
                this.adminId(instance.adminId());
                Integer receiveDateValue = instance.receiveDate();
                if (receiveDateValue != null) {
                    this.receiveDate(receiveDateValue);
                }
                this.accessHash(instance.accessHash());
                this.video(instance.video());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder participantId(long participantId) {
            this.participantId = participantId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder protocol(PhoneCallProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder receiveDate(@Nullable Integer receiveDate) {
            this.receiveDate = receiveDate;
            return this;
        }

        public ImmutablePhoneCallWaiting build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoneCallWaiting(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("participantId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("protocol");
            }
            return "Cannot build PhoneCallWaiting, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhoneCallWaiting.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePhoneCallWaiting.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutablePhoneCallWaiting.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build PhoneCallWaiting, attribute initializers form cycle " + attributes;
        }
    }
}

