/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PhoneConnection;
import telegram4j.tl.PhoneConnectionWebrtc;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhoneConnectionWebrtc
implements PhoneConnectionWebrtc {
    private final int identifier;
    private final int flags;
    private final boolean turn;
    private final boolean stun;
    private final long id;
    private final String ip;
    private final String ipv6;
    private final int port;
    private final String username;
    private final String password;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhoneConnectionWebrtc(long id, String ip, String ipv6, int port, String username, String password) {
        this.id = id;
        this.ip = Objects.requireNonNull(ip, "ip");
        this.ipv6 = Objects.requireNonNull(ipv6, "ipv6");
        this.port = port;
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.turn = this.initShim.turn();
        this.stun = this.initShim.stun();
        this.initShim = null;
    }

    private ImmutablePhoneConnectionWebrtc(Builder builder) {
        this.id = builder.id;
        this.ip = builder.ip;
        this.ipv6 = builder.ipv6;
        this.port = builder.port;
        this.username = builder.username;
        this.password = builder.password;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.turnIsSet()) {
            this.initShim.turn(builder.turn);
        }
        if (builder.stunIsSet()) {
            this.initShim.stun(builder.stun);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.turn = this.initShim.turn();
        this.stun = this.initShim.stun();
        this.initShim = null;
    }

    private ImmutablePhoneConnectionWebrtc(int identifier, int flags, boolean turn, boolean stun, long id, String ip, String ipv6, int port, String username, String password) {
        this.identifier = identifier;
        this.flags = flags;
        this.turn = turn;
        this.stun = stun;
        this.id = id;
        this.ip = ip;
        this.ipv6 = ipv6;
        this.port = port;
        this.username = username;
        this.password = password;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhoneConnectionWebrtc.super.identifier();
    }

    private int flagsInitialize() {
        return PhoneConnectionWebrtc.super.flags();
    }

    private boolean turnInitialize() {
        return PhoneConnectionWebrtc.super.turn();
    }

    private boolean stunInitialize() {
        return PhoneConnectionWebrtc.super.stun();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean turn() {
        InitShim shim = this.initShim;
        return shim != null ? shim.turn() : this.turn;
    }

    @Override
    public boolean stun() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stun() : this.stun;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public String ipv6() {
        return this.ipv6;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    public final ImmutablePhoneConnectionWebrtc withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(value, this.flags, this.turn, this.stun, this.id, this.ip, this.ipv6, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, value, this.turn, this.stun, this.id, this.ip, this.ipv6, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withTurn(boolean value) {
        if (this.turn == value) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, value, this.stun, this.id, this.ip, this.ipv6, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withStun(boolean value) {
        if (this.stun == value) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, value, this.id, this.ip, this.ipv6, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, this.stun, value, this.ip, this.ipv6, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withIp(String value) {
        String newValue = Objects.requireNonNull(value, "ip");
        if (this.ip.equals(newValue)) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, this.stun, this.id, newValue, this.ipv6, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withIpv6(String value) {
        String newValue = Objects.requireNonNull(value, "ipv6");
        if (this.ipv6.equals(newValue)) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, this.stun, this.id, this.ip, newValue, this.port, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, this.stun, this.id, this.ip, this.ipv6, value, this.username, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, this.stun, this.id, this.ip, this.ipv6, this.port, newValue, this.password);
    }

    public final ImmutablePhoneConnectionWebrtc withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutablePhoneConnectionWebrtc(this.identifier, this.flags, this.turn, this.stun, this.id, this.ip, this.ipv6, this.port, this.username, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoneConnectionWebrtc && this.equalTo(0, (ImmutablePhoneConnectionWebrtc)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoneConnectionWebrtc another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.turn == another.turn && this.stun == another.stun && this.id == another.id && this.ip.equals(another.ip) && this.ipv6.equals(another.ipv6) && this.port == another.port && this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.turn);
        h += (h << 5) + Boolean.hashCode(this.stun);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.ip.hashCode();
        h += (h << 5) + this.ipv6.hashCode();
        h += (h << 5) + this.port;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return "PhoneConnectionWebrtc{identifier=" + this.identifier + ", flags=" + this.flags + ", turn=" + this.turn + ", stun=" + this.stun + ", id=" + this.id + ", ip=" + this.ip + ", ipv6=" + this.ipv6 + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + "}";
    }

    public static ImmutablePhoneConnectionWebrtc of(long id, String ip, String ipv6, int port, String username, String password) {
        return new ImmutablePhoneConnectionWebrtc(id, ip, ipv6, port, username, password);
    }

    public static ImmutablePhoneConnectionWebrtc copyOf(PhoneConnectionWebrtc instance) {
        if (instance instanceof ImmutablePhoneConnectionWebrtc) {
            return (ImmutablePhoneConnectionWebrtc)instance;
        }
        return ImmutablePhoneConnectionWebrtc.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IP = 2L;
        private static final long INIT_BIT_IPV6 = 4L;
        private static final long INIT_BIT_PORT = 8L;
        private static final long INIT_BIT_USERNAME = 16L;
        private static final long INIT_BIT_PASSWORD = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_TURN = 4L;
        private static final long OPT_BIT_STUN = 8L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean turn;
        private boolean stun;
        private long id;
        private String ip;
        private String ipv6;
        private int port;
        private String username;
        private String password;

        private Builder() {
        }

        public final Builder from(PhoneConnection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhoneConnectionWebrtc instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneConnection instance;
            long bits = 0L;
            if (object instanceof PhoneConnection) {
                instance = (PhoneConnection)object;
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.port(instance.port());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.ipv6(instance.ipv6());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.ip(instance.ip());
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhoneConnectionWebrtc) {
                instance = (PhoneConnectionWebrtc)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.password(instance.password());
                if ((bits & 2L) == 0L) {
                    this.port(instance.port());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.ipv6(instance.ipv6());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.ip(instance.ip());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                this.turn(instance.turn());
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
                this.stun(instance.stun());
                this.username(instance.username());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder turn(boolean turn) {
            this.turn = turn;
            this.optBits |= 4L;
            return this;
        }

        public final Builder stun(boolean stun) {
            this.stun = stun;
            this.optBits |= 8L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ip(String ip) {
            this.ip = Objects.requireNonNull(ip, "ip");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ipv6(String ipv6) {
            this.ipv6 = Objects.requireNonNull(ipv6, "ipv6");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePhoneConnectionWebrtc build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoneConnectionWebrtc(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean turnIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean stunIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ip");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ipv6");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build PhoneConnectionWebrtc, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte turnBuildStage = 0;
        private boolean turn;
        private byte stunBuildStage = 0;
        private boolean stun;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhoneConnectionWebrtc.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePhoneConnectionWebrtc.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean turn() {
            if (this.turnBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.turnBuildStage == 0) {
                this.turnBuildStage = (byte)-1;
                this.turn = ImmutablePhoneConnectionWebrtc.this.turnInitialize();
                this.turnBuildStage = 1;
            }
            return this.turn;
        }

        void turn(boolean turn) {
            this.turn = turn;
            this.turnBuildStage = 1;
        }

        boolean stun() {
            if (this.stunBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stunBuildStage == 0) {
                this.stunBuildStage = (byte)-1;
                this.stun = ImmutablePhoneConnectionWebrtc.this.stunInitialize();
                this.stunBuildStage = 1;
            }
            return this.stun;
        }

        void stun(boolean stun) {
            this.stun = stun;
            this.stunBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.turnBuildStage == -1) {
                attributes.add("turn");
            }
            if (this.stunBuildStage == -1) {
                attributes.add("stun");
            }
            return "Cannot build PhoneConnectionWebrtc, attribute initializers form cycle " + attributes;
        }
    }
}

