/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PhotoCachedSize;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhotoCachedSize
implements PhotoCachedSize {
    private final int identifier;
    private final String type;
    private final int w;
    private final int h;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhotoCachedSize(String type, int w, int h) {
        this.type = Objects.requireNonNull(type, "type");
        this.w = w;
        this.h = h;
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePhotoCachedSize(Builder builder) {
        this.type = builder.type;
        this.w = builder.w;
        this.h = builder.h;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePhotoCachedSize(int identifier, String type, int w, int h, ByteBuf bytes) {
        this.identifier = identifier;
        this.type = type;
        this.w = w;
        this.h = h;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhotoCachedSize.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutablePhotoCachedSize withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhotoCachedSize(value, this.type, this.w, this.h, this.bytes);
    }

    public final ImmutablePhotoCachedSize withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutablePhotoCachedSize(this.identifier, newValue, this.w, this.h, this.bytes);
    }

    public final ImmutablePhotoCachedSize withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutablePhotoCachedSize(this.identifier, this.type, value, this.h, this.bytes);
    }

    public final ImmutablePhotoCachedSize withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutablePhotoCachedSize(this.identifier, this.type, this.w, value, this.bytes);
    }

    public ImmutablePhotoCachedSize withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutablePhotoCachedSize(this.identifier, this.type, this.w, this.h, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhotoCachedSize && this.equalTo(0, (ImmutablePhotoCachedSize)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhotoCachedSize another) {
        return this.identifier == another.identifier && this.type.equals(another.type) && this.w == another.w && this.h == another.h && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.type.hashCode();
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        h$$ += (h$$ << 5) + this.bytes().hashCode();
        return h$$;
    }

    public String toString() {
        return "PhotoCachedSize{identifier=" + this.identifier + ", type=" + this.type + ", w=" + this.w + ", h=" + this.h + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutablePhotoCachedSize of(String type, int w, int h) {
        return new ImmutablePhotoCachedSize(type, w, h);
    }

    public static ImmutablePhotoCachedSize copyOf(PhotoCachedSize instance) {
        if (instance instanceof ImmutablePhotoCachedSize) {
            return (ImmutablePhotoCachedSize)instance;
        }
        return ImmutablePhotoCachedSize.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_W = 2L;
        private static final long INIT_BIT_H = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private String type;
        private int w;
        private int h;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoCachedSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhotoCachedSize) {
                instance = (PhotoCachedSize)object;
                this.h(instance.h());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                this.bytes(instance.bytes());
                this.w(instance.w());
            }
            if (object instanceof PhotoSize) {
                instance = (PhotoSize)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutablePhotoCachedSize build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhotoCachedSize(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("h");
            }
            return "Cannot build PhotoCachedSize, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhotoCachedSize.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build PhotoCachedSize, attribute initializers form cycle " + attributes;
        }
    }
}

