/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.PhotoSizeEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhotoSizeEmpty
implements PhotoSizeEmpty {
    private final int identifier;
    private final String type;

    private ImmutablePhotoSizeEmpty(String type) {
        this.type = Objects.requireNonNull(type, "type");
        this.identifier = PhotoSizeEmpty.super.identifier();
    }

    private ImmutablePhotoSizeEmpty(Builder builder) {
        this.type = builder.type;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PhotoSizeEmpty.super.identifier();
    }

    private ImmutablePhotoSizeEmpty(int identifier, String type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String type() {
        return this.type;
    }

    public final ImmutablePhotoSizeEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhotoSizeEmpty(value, this.type);
    }

    public final ImmutablePhotoSizeEmpty withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutablePhotoSizeEmpty(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhotoSizeEmpty && this.equalTo(0, (ImmutablePhotoSizeEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhotoSizeEmpty another) {
        return this.identifier == another.identifier && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "PhotoSizeEmpty{identifier=" + this.identifier + ", type=" + this.type + "}";
    }

    public static ImmutablePhotoSizeEmpty of(String type) {
        return new ImmutablePhotoSizeEmpty(type);
    }

    public static ImmutablePhotoSizeEmpty copyOf(PhotoSizeEmpty instance) {
        if (instance instanceof ImmutablePhotoSizeEmpty) {
            return (ImmutablePhotoSizeEmpty)instance;
        }
        return ImmutablePhotoSizeEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String type;

        private Builder() {
        }

        public final Builder from(PhotoSizeEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhotoSize instance;
            long bits = 0L;
            if (object instanceof PhotoSizeEmpty) {
                instance = (PhotoSizeEmpty)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhotoSize) {
                instance = (PhotoSize)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePhotoSizeEmpty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhotoSizeEmpty(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build PhotoSizeEmpty, some of required attributes are not set " + attributes;
        }
    }
}

