/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.PhotoSizeProgressive;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhotoSizeProgressive
implements PhotoSizeProgressive {
    private final int identifier;
    private final String type;
    private final int w;
    private final int h;
    private final List<Integer> sizes;

    private ImmutablePhotoSizeProgressive(String type, int w, int h) {
        this.type = Objects.requireNonNull(type, "type");
        this.w = w;
        this.h = h;
        this.sizes = Collections.emptyList();
        this.identifier = PhotoSizeProgressive.super.identifier();
    }

    private ImmutablePhotoSizeProgressive(Builder builder) {
        this.type = builder.type;
        this.w = builder.w;
        this.h = builder.h;
        this.sizes = ImmutablePhotoSizeProgressive.createUnmodifiableList(true, builder.sizes);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PhotoSizeProgressive.super.identifier();
    }

    private ImmutablePhotoSizeProgressive(int identifier, String type, int w, int h, List<Integer> sizes) {
        this.identifier = identifier;
        this.type = type;
        this.w = w;
        this.h = h;
        this.sizes = sizes;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public List<Integer> sizes() {
        return this.sizes;
    }

    public final ImmutablePhotoSizeProgressive withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhotoSizeProgressive(value, this.type, this.w, this.h, this.sizes);
    }

    public final ImmutablePhotoSizeProgressive withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutablePhotoSizeProgressive(this.identifier, newValue, this.w, this.h, this.sizes);
    }

    public final ImmutablePhotoSizeProgressive withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutablePhotoSizeProgressive(this.identifier, this.type, value, this.h, this.sizes);
    }

    public final ImmutablePhotoSizeProgressive withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutablePhotoSizeProgressive(this.identifier, this.type, this.w, value, this.sizes);
    }

    public final ImmutablePhotoSizeProgressive withSizes(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutablePhotoSizeProgressive.createUnmodifiableList(false, wrappedList);
        return new ImmutablePhotoSizeProgressive(this.identifier, this.type, this.w, this.h, newValue);
    }

    public final ImmutablePhotoSizeProgressive withSizes(Iterable<Integer> elements) {
        if (this.sizes == elements) {
            return this;
        }
        List<Integer> newValue = ImmutablePhotoSizeProgressive.createUnmodifiableList(false, ImmutablePhotoSizeProgressive.createSafeList(elements, true, false));
        return new ImmutablePhotoSizeProgressive(this.identifier, this.type, this.w, this.h, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhotoSizeProgressive && this.equalTo(0, (ImmutablePhotoSizeProgressive)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhotoSizeProgressive another) {
        return this.identifier == another.identifier && this.type.equals(another.type) && this.w == another.w && this.h == another.h && this.sizes.equals(another.sizes);
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.type.hashCode();
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        h$$ += (h$$ << 5) + this.sizes.hashCode();
        return h$$;
    }

    public String toString() {
        return "PhotoSizeProgressive{identifier=" + this.identifier + ", type=" + this.type + ", w=" + this.w + ", h=" + this.h + ", sizes=" + this.sizes + "}";
    }

    public static ImmutablePhotoSizeProgressive of(String type, int w, int h) {
        return new ImmutablePhotoSizeProgressive(type, w, h);
    }

    public static ImmutablePhotoSizeProgressive copyOf(PhotoSizeProgressive instance) {
        if (instance instanceof ImmutablePhotoSizeProgressive) {
            return (ImmutablePhotoSizeProgressive)instance;
        }
        return ImmutablePhotoSizeProgressive.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_W = 2L;
        private static final long INIT_BIT_H = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String type;
        private int w;
        private int h;
        private List<Integer> sizes = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(PhotoSizeProgressive instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhotoSize instance;
            long bits = 0L;
            if (object instanceof PhotoSizeProgressive) {
                instance = (PhotoSizeProgressive)object;
                this.h(instance.h());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllSizes(instance.sizes());
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                this.w(instance.w());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhotoSize) {
                instance = (PhotoSize)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addSize(int element) {
            this.sizes.add(element);
            return this;
        }

        public final Builder addSizes(int ... elements) {
            for (int element : elements) {
                this.sizes.add(element);
            }
            return this;
        }

        public final Builder sizes(Iterable<Integer> elements) {
            this.sizes.clear();
            return this.addAllSizes(elements);
        }

        public final Builder addAllSizes(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.sizes.add(Objects.requireNonNull(element, "sizes element"));
            }
            return this;
        }

        public ImmutablePhotoSizeProgressive build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhotoSizeProgressive(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("h");
            }
            return "Cannot build PhotoSizeProgressive, some of required attributes are not set " + attributes;
        }
    }
}

