/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.PhotoStrippedSize;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhotoStrippedSize
implements PhotoStrippedSize {
    private final int identifier;
    private final String type;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePhotoStrippedSize(String type) {
        this.type = Objects.requireNonNull(type, "type");
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePhotoStrippedSize(Builder builder) {
        this.type = builder.type;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePhotoStrippedSize(int identifier, String type, ByteBuf bytes) {
        this.identifier = identifier;
        this.type = type;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PhotoStrippedSize.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutablePhotoStrippedSize withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhotoStrippedSize(value, this.type, this.bytes);
    }

    public final ImmutablePhotoStrippedSize withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutablePhotoStrippedSize(this.identifier, newValue, this.bytes);
    }

    public ImmutablePhotoStrippedSize withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutablePhotoStrippedSize(this.identifier, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhotoStrippedSize && this.equalTo(0, (ImmutablePhotoStrippedSize)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhotoStrippedSize another) {
        return this.identifier == another.identifier && this.type.equals(another.type) && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.bytes().hashCode();
        return h;
    }

    public String toString() {
        return "PhotoStrippedSize{identifier=" + this.identifier + ", type=" + this.type + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutablePhotoStrippedSize of(String type) {
        return new ImmutablePhotoStrippedSize(type);
    }

    public static ImmutablePhotoStrippedSize copyOf(PhotoStrippedSize instance) {
        if (instance instanceof ImmutablePhotoStrippedSize) {
            return (ImmutablePhotoStrippedSize)instance;
        }
        return ImmutablePhotoStrippedSize.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private String type;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoStrippedSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhotoSize) {
                instance = (PhotoSize)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhotoStrippedSize) {
                instance = (PhotoStrippedSize)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.bytes(instance.bytes());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutablePhotoStrippedSize build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhotoStrippedSize(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build PhotoStrippedSize, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePhotoStrippedSize.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build PhotoStrippedSize, attribute initializers form cycle " + attributes;
        }
    }
}

