/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Poll;
import telegram4j.tl.PollAnswer;
import telegram4j.tl.api.TlObject;

public final class ImmutablePoll
implements Poll {
    private final int identifier;
    private final long id;
    private final int flags;
    private final boolean closed;
    private final boolean publicVoters;
    private final boolean multipleChoice;
    private final boolean quiz;
    private final String question;
    private final List<PollAnswer> answers;
    @Nullable
    private final Integer closePeriod;
    @Nullable
    private final Integer closeDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePoll(long id, String question) {
        this.id = id;
        this.question = Objects.requireNonNull(question, "question");
        this.answers = Collections.emptyList();
        this.closePeriod = null;
        this.closeDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.closed = this.initShim.closed();
        this.publicVoters = this.initShim.publicVoters();
        this.multipleChoice = this.initShim.multipleChoice();
        this.quiz = this.initShim.quiz();
        this.initShim = null;
    }

    private ImmutablePoll(Builder builder) {
        this.id = builder.id;
        this.question = builder.question;
        this.answers = ImmutablePoll.createUnmodifiableList(true, builder.answers);
        this.closePeriod = builder.closePeriod;
        this.closeDate = builder.closeDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.closedIsSet()) {
            this.initShim.closed(builder.closed);
        }
        if (builder.publicVotersIsSet()) {
            this.initShim.publicVoters(builder.publicVoters);
        }
        if (builder.multipleChoiceIsSet()) {
            this.initShim.multipleChoice(builder.multipleChoice);
        }
        if (builder.quizIsSet()) {
            this.initShim.quiz(builder.quiz);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.closed = this.initShim.closed();
        this.publicVoters = this.initShim.publicVoters();
        this.multipleChoice = this.initShim.multipleChoice();
        this.quiz = this.initShim.quiz();
        this.initShim = null;
    }

    private ImmutablePoll(int identifier, long id, int flags, boolean closed, boolean publicVoters, boolean multipleChoice, boolean quiz, String question, List<PollAnswer> answers, @Nullable Integer closePeriod, @Nullable Integer closeDate) {
        this.identifier = identifier;
        this.id = id;
        this.flags = flags;
        this.closed = closed;
        this.publicVoters = publicVoters;
        this.multipleChoice = multipleChoice;
        this.quiz = quiz;
        this.question = question;
        this.answers = answers;
        this.closePeriod = closePeriod;
        this.closeDate = closeDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Poll.super.identifier();
    }

    private int flagsInitialize() {
        return Poll.super.flags();
    }

    private boolean closedInitialize() {
        return Poll.super.closed();
    }

    private boolean publicVotersInitialize() {
        return Poll.super.publicVoters();
    }

    private boolean multipleChoiceInitialize() {
        return Poll.super.multipleChoice();
    }

    private boolean quizInitialize() {
        return Poll.super.quiz();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean closed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.closed() : this.closed;
    }

    @Override
    public boolean publicVoters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.publicVoters() : this.publicVoters;
    }

    @Override
    public boolean multipleChoice() {
        InitShim shim = this.initShim;
        return shim != null ? shim.multipleChoice() : this.multipleChoice;
    }

    @Override
    public boolean quiz() {
        InitShim shim = this.initShim;
        return shim != null ? shim.quiz() : this.quiz;
    }

    @Override
    public String question() {
        return this.question;
    }

    @Override
    public List<PollAnswer> answers() {
        return this.answers;
    }

    @Override
    @Nullable
    public Integer closePeriod() {
        return this.closePeriod;
    }

    @Override
    @Nullable
    public Integer closeDate() {
        return this.closeDate;
    }

    public final ImmutablePoll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePoll(value, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutablePoll(this.identifier, value, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, value, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withClosed(boolean value) {
        if (this.closed == value) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, value, this.publicVoters, this.multipleChoice, this.quiz, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withPublicVoters(boolean value) {
        if (this.publicVoters == value) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, value, this.multipleChoice, this.quiz, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withMultipleChoice(boolean value) {
        if (this.multipleChoice == value) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, value, this.quiz, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withQuiz(boolean value) {
        if (this.quiz == value) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, value, this.question, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withQuestion(String value) {
        String newValue = Objects.requireNonNull(value, "question");
        if (this.question.equals(newValue)) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, newValue, this.answers, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withAnswers(PollAnswer ... elements) {
        List<PollAnswer> newValue = ImmutablePoll.createUnmodifiableList(false, ImmutablePoll.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, newValue, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withAnswers(Iterable<? extends PollAnswer> elements) {
        if (this.answers == elements) {
            return this;
        }
        List<PollAnswer> newValue = ImmutablePoll.createUnmodifiableList(false, ImmutablePoll.createSafeList(elements, true, false));
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, newValue, this.closePeriod, this.closeDate);
    }

    public final ImmutablePoll withClosePeriod(@Nullable Integer value) {
        if (Objects.equals(this.closePeriod, value)) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, this.answers, value, this.closeDate);
    }

    public final ImmutablePoll withCloseDate(@Nullable Integer value) {
        if (Objects.equals(this.closeDate, value)) {
            return this;
        }
        return new ImmutablePoll(this.identifier, this.id, this.flags, this.closed, this.publicVoters, this.multipleChoice, this.quiz, this.question, this.answers, this.closePeriod, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePoll && this.equalTo(0, (ImmutablePoll)another);
    }

    private boolean equalTo(int synthetic, ImmutablePoll another) {
        return this.identifier == another.identifier && this.id == another.id && this.flags == another.flags && this.closed == another.closed && this.publicVoters == another.publicVoters && this.multipleChoice == another.multipleChoice && this.quiz == another.quiz && this.question.equals(another.question) && this.answers.equals(another.answers) && Objects.equals(this.closePeriod, another.closePeriod) && Objects.equals(this.closeDate, another.closeDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.closed);
        h += (h << 5) + Boolean.hashCode(this.publicVoters);
        h += (h << 5) + Boolean.hashCode(this.multipleChoice);
        h += (h << 5) + Boolean.hashCode(this.quiz);
        h += (h << 5) + this.question.hashCode();
        h += (h << 5) + this.answers.hashCode();
        h += (h << 5) + Objects.hashCode(this.closePeriod);
        h += (h << 5) + Objects.hashCode(this.closeDate);
        return h;
    }

    public String toString() {
        return "Poll{identifier=" + this.identifier + ", id=" + this.id + ", flags=" + this.flags + ", closed=" + this.closed + ", publicVoters=" + this.publicVoters + ", multipleChoice=" + this.multipleChoice + ", quiz=" + this.quiz + ", question=" + this.question + ", answers=" + this.answers + ", closePeriod=" + this.closePeriod + ", closeDate=" + this.closeDate + "}";
    }

    public static ImmutablePoll of(long id, String question) {
        return new ImmutablePoll(id, question);
    }

    public static ImmutablePoll copyOf(Poll instance) {
        if (instance instanceof ImmutablePoll) {
            return (ImmutablePoll)instance;
        }
        return ImmutablePoll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_QUESTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CLOSED = 4L;
        private static final long OPT_BIT_PUBLIC_VOTERS = 8L;
        private static final long OPT_BIT_MULTIPLE_CHOICE = 16L;
        private static final long OPT_BIT_QUIZ = 32L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long id;
        private int flags;
        private boolean closed;
        private boolean publicVoters;
        private boolean multipleChoice;
        private boolean quiz;
        private String question;
        private List<PollAnswer> answers = new ArrayList<PollAnswer>();
        private Integer closePeriod;
        private Integer closeDate;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Poll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Poll) {
                instance = (Poll)object;
                this.quiz(instance.quiz());
                Integer closeDateValue = instance.closeDate();
                if (closeDateValue != null) {
                    this.closeDate(closeDateValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.question(instance.question());
                Integer closePeriodValue = instance.closePeriod();
                if (closePeriodValue != null) {
                    this.closePeriod(closePeriodValue);
                }
                this.publicVoters(instance.publicVoters());
                this.flags(instance.flags());
                this.addAllAnswers(instance.answers());
                this.closed(instance.closed());
                this.id(instance.id());
                this.multipleChoice(instance.multipleChoice());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder closed(boolean closed) {
            this.closed = closed;
            this.optBits |= 4L;
            return this;
        }

        public final Builder publicVoters(boolean publicVoters) {
            this.publicVoters = publicVoters;
            this.optBits |= 8L;
            return this;
        }

        public final Builder multipleChoice(boolean multipleChoice) {
            this.multipleChoice = multipleChoice;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder quiz(boolean quiz) {
            this.quiz = quiz;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder question(String question) {
            this.question = Objects.requireNonNull(question, "question");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addAnswer(PollAnswer element) {
            this.answers.add(Objects.requireNonNull(element, "answers element"));
            return this;
        }

        public final Builder addAnswers(PollAnswer ... elements) {
            for (PollAnswer element : elements) {
                this.answers.add(Objects.requireNonNull(element, "answers element"));
            }
            return this;
        }

        public final Builder answers(Iterable<? extends PollAnswer> elements) {
            this.answers.clear();
            return this.addAllAnswers(elements);
        }

        public final Builder addAllAnswers(Iterable<? extends PollAnswer> elements) {
            for (PollAnswer pollAnswer : elements) {
                this.answers.add(Objects.requireNonNull(pollAnswer, "answers element"));
            }
            return this;
        }

        public final Builder closePeriod(@Nullable Integer closePeriod) {
            this.closePeriod = closePeriod;
            return this;
        }

        public final Builder closeDate(@Nullable Integer closeDate) {
            this.closeDate = closeDate;
            return this;
        }

        public ImmutablePoll build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePoll(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean closedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean publicVotersIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean multipleChoiceIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean quizIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("question");
            }
            return "Cannot build Poll, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte closedBuildStage = 0;
        private boolean closed;
        private byte publicVotersBuildStage = 0;
        private boolean publicVoters;
        private byte multipleChoiceBuildStage = 0;
        private boolean multipleChoice;
        private byte quizBuildStage = 0;
        private boolean quiz;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePoll.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePoll.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean closed() {
            if (this.closedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.closedBuildStage == 0) {
                this.closedBuildStage = (byte)-1;
                this.closed = ImmutablePoll.this.closedInitialize();
                this.closedBuildStage = 1;
            }
            return this.closed;
        }

        void closed(boolean closed) {
            this.closed = closed;
            this.closedBuildStage = 1;
        }

        boolean publicVoters() {
            if (this.publicVotersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.publicVotersBuildStage == 0) {
                this.publicVotersBuildStage = (byte)-1;
                this.publicVoters = ImmutablePoll.this.publicVotersInitialize();
                this.publicVotersBuildStage = 1;
            }
            return this.publicVoters;
        }

        void publicVoters(boolean publicVoters) {
            this.publicVoters = publicVoters;
            this.publicVotersBuildStage = 1;
        }

        boolean multipleChoice() {
            if (this.multipleChoiceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.multipleChoiceBuildStage == 0) {
                this.multipleChoiceBuildStage = (byte)-1;
                this.multipleChoice = ImmutablePoll.this.multipleChoiceInitialize();
                this.multipleChoiceBuildStage = 1;
            }
            return this.multipleChoice;
        }

        void multipleChoice(boolean multipleChoice) {
            this.multipleChoice = multipleChoice;
            this.multipleChoiceBuildStage = 1;
        }

        boolean quiz() {
            if (this.quizBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.quizBuildStage == 0) {
                this.quizBuildStage = (byte)-1;
                this.quiz = ImmutablePoll.this.quizInitialize();
                this.quizBuildStage = 1;
            }
            return this.quiz;
        }

        void quiz(boolean quiz) {
            this.quiz = quiz;
            this.quizBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.closedBuildStage == -1) {
                attributes.add("closed");
            }
            if (this.publicVotersBuildStage == -1) {
                attributes.add("publicVoters");
            }
            if (this.multipleChoiceBuildStage == -1) {
                attributes.add("multipleChoice");
            }
            if (this.quizBuildStage == -1) {
                attributes.add("quiz");
            }
            return "Cannot build Poll, attribute initializers form cycle " + attributes;
        }
    }
}

