/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PollAnswer;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePollAnswer
implements PollAnswer {
    private final int identifier;
    private final String text;
    private final ByteBuf option;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollAnswer(String text) {
        this.text = Objects.requireNonNull(text, "text");
        this.option = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePollAnswer(Builder builder) {
        this.text = builder.text;
        this.option = builder.option_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePollAnswer(int identifier, String text, ByteBuf option) {
        this.identifier = identifier;
        this.text = text;
        this.option = option;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PollAnswer.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public ByteBuf option() {
        return this.option.duplicate();
    }

    public final ImmutablePollAnswer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePollAnswer(value, this.text, this.option);
    }

    public final ImmutablePollAnswer withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutablePollAnswer(this.identifier, newValue, this.option);
    }

    public ImmutablePollAnswer withOption(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.option == newValue) {
            return this;
        }
        return new ImmutablePollAnswer(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollAnswer && this.equalTo(0, (ImmutablePollAnswer)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollAnswer another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.option().equals((Object)another.option());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.option().hashCode();
        return h;
    }

    public String toString() {
        return "PollAnswer{identifier=" + this.identifier + ", text=" + this.text + ", option=" + ByteBufUtil.hexDump((ByteBuf)this.option) + "}";
    }

    public static ImmutablePollAnswer of(String text) {
        return new ImmutablePollAnswer(text);
    }

    public static ImmutablePollAnswer copyOf(PollAnswer instance) {
        if (instance instanceof ImmutablePollAnswer) {
            return (ImmutablePollAnswer)instance;
        }
        return ImmutablePollAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf option_value = null;
        private int identifier;
        private String text;

        private Builder() {
        }

        public final Builder from(PollAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PollAnswer instance;
            long bits = 0L;
            if (object instanceof PollAnswer) {
                instance = (PollAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
                this.option(instance.option());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder option(ByteBuf value) {
            this.option_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutablePollAnswer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePollAnswer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build PollAnswer, some of required attributes are not set " + attributes;
        }

        private ByteBuf option_build() {
            return Objects.requireNonNull(this.option_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePollAnswer.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build PollAnswer, attribute initializers form cycle " + attributes;
        }
    }
}

