/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PollAnswerVoters;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePollAnswerVoters
implements PollAnswerVoters {
    private final int identifier;
    private final int flags;
    private final boolean chosen;
    private final boolean correct;
    private final ByteBuf option;
    private final int voters;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollAnswerVoters(int voters) {
        this.voters = voters;
        this.option = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.chosen = this.initShim.chosen();
        this.correct = this.initShim.correct();
        this.initShim = null;
    }

    private ImmutablePollAnswerVoters(Builder builder) {
        this.option = builder.option_build();
        this.voters = builder.voters;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.chosenIsSet()) {
            this.initShim.chosen(builder.chosen);
        }
        if (builder.correctIsSet()) {
            this.initShim.correct(builder.correct);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.chosen = this.initShim.chosen();
        this.correct = this.initShim.correct();
        this.initShim = null;
    }

    private ImmutablePollAnswerVoters(int identifier, int flags, boolean chosen, boolean correct, ByteBuf option, int voters) {
        this.identifier = identifier;
        this.flags = flags;
        this.chosen = chosen;
        this.correct = correct;
        this.option = option;
        this.voters = voters;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PollAnswerVoters.super.identifier();
    }

    private int flagsInitialize() {
        return PollAnswerVoters.super.flags();
    }

    private boolean chosenInitialize() {
        return PollAnswerVoters.super.chosen();
    }

    private boolean correctInitialize() {
        return PollAnswerVoters.super.correct();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean chosen() {
        InitShim shim = this.initShim;
        return shim != null ? shim.chosen() : this.chosen;
    }

    @Override
    public boolean correct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.correct() : this.correct;
    }

    @Override
    public ByteBuf option() {
        return this.option.duplicate();
    }

    @Override
    public int voters() {
        return this.voters;
    }

    public final ImmutablePollAnswerVoters withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePollAnswerVoters(value, this.flags, this.chosen, this.correct, this.option, this.voters);
    }

    public final ImmutablePollAnswerVoters withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePollAnswerVoters(this.identifier, value, this.chosen, this.correct, this.option, this.voters);
    }

    public final ImmutablePollAnswerVoters withChosen(boolean value) {
        if (this.chosen == value) {
            return this;
        }
        return new ImmutablePollAnswerVoters(this.identifier, this.flags, value, this.correct, this.option, this.voters);
    }

    public final ImmutablePollAnswerVoters withCorrect(boolean value) {
        if (this.correct == value) {
            return this;
        }
        return new ImmutablePollAnswerVoters(this.identifier, this.flags, this.chosen, value, this.option, this.voters);
    }

    public ImmutablePollAnswerVoters withOption(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.option == newValue) {
            return this;
        }
        return new ImmutablePollAnswerVoters(this.identifier, this.flags, this.chosen, this.correct, newValue, this.voters);
    }

    public final ImmutablePollAnswerVoters withVoters(int value) {
        if (this.voters == value) {
            return this;
        }
        return new ImmutablePollAnswerVoters(this.identifier, this.flags, this.chosen, this.correct, this.option, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollAnswerVoters && this.equalTo(0, (ImmutablePollAnswerVoters)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollAnswerVoters another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.chosen == another.chosen && this.correct == another.correct && this.option().equals((Object)another.option()) && this.voters == another.voters;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.chosen);
        h += (h << 5) + Boolean.hashCode(this.correct);
        h += (h << 5) + this.option().hashCode();
        h += (h << 5) + this.voters;
        return h;
    }

    public String toString() {
        return "PollAnswerVoters{identifier=" + this.identifier + ", flags=" + this.flags + ", chosen=" + this.chosen + ", correct=" + this.correct + ", option=" + ByteBufUtil.hexDump((ByteBuf)this.option) + ", voters=" + this.voters + "}";
    }

    public static ImmutablePollAnswerVoters of(int voters) {
        return new ImmutablePollAnswerVoters(voters);
    }

    public static ImmutablePollAnswerVoters copyOf(PollAnswerVoters instance) {
        if (instance instanceof ImmutablePollAnswerVoters) {
            return (ImmutablePollAnswerVoters)instance;
        }
        return ImmutablePollAnswerVoters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VOTERS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CHOSEN = 4L;
        private static final long OPT_BIT_CORRECT = 8L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf option_value = null;
        private int identifier;
        private int flags;
        private boolean chosen;
        private boolean correct;
        private int voters;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PollAnswerVoters instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PollAnswerVoters) {
                instance = (PollAnswerVoters)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.correct(instance.correct());
                this.voters(instance.voters());
                this.chosen(instance.chosen());
                this.option(instance.option());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder chosen(boolean chosen) {
            this.chosen = chosen;
            this.optBits |= 4L;
            return this;
        }

        public final Builder correct(boolean correct) {
            this.correct = correct;
            this.optBits |= 8L;
            return this;
        }

        public Builder option(ByteBuf value) {
            this.option_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder voters(int voters) {
            this.voters = voters;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePollAnswerVoters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePollAnswerVoters(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean chosenIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean correctIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("voters");
            }
            return "Cannot build PollAnswerVoters, some of required attributes are not set " + attributes;
        }

        private ByteBuf option_build() {
            return Objects.requireNonNull(this.option_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte chosenBuildStage = 0;
        private boolean chosen;
        private byte correctBuildStage = 0;
        private boolean correct;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePollAnswerVoters.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePollAnswerVoters.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean chosen() {
            if (this.chosenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.chosenBuildStage == 0) {
                this.chosenBuildStage = (byte)-1;
                this.chosen = ImmutablePollAnswerVoters.this.chosenInitialize();
                this.chosenBuildStage = 1;
            }
            return this.chosen;
        }

        void chosen(boolean chosen) {
            this.chosen = chosen;
            this.chosenBuildStage = 1;
        }

        boolean correct() {
            if (this.correctBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.correctBuildStage == 0) {
                this.correctBuildStage = (byte)-1;
                this.correct = ImmutablePollAnswerVoters.this.correctInitialize();
                this.correctBuildStage = 1;
            }
            return this.correct;
        }

        void correct(boolean correct) {
            this.correct = correct;
            this.correctBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.chosenBuildStage == -1) {
                attributes.add("chosen");
            }
            if (this.correctBuildStage == -1) {
                attributes.add("correct");
            }
            return "Cannot build PollAnswerVoters, attribute initializers form cycle " + attributes;
        }
    }
}

