/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.PollAnswerVoters;
import telegram4j.tl.PollResults;
import telegram4j.tl.api.TlObject;

public final class ImmutablePollResults
implements PollResults {
    private final int identifier;
    private final int flags;
    private final boolean min;
    @Nullable
    private final List<PollAnswerVoters> results;
    @Nullable
    private final Integer totalVoters;
    @Nullable
    private final List<Long> recentVoters;
    @Nullable
    private final String solution;
    @Nullable
    private final List<MessageEntity> solutionEntities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePollResults INSTANCE = ImmutablePollResults.validate(new ImmutablePollResults());

    private ImmutablePollResults() {
        this.results = null;
        this.totalVoters = null;
        this.recentVoters = null;
        this.solution = null;
        this.solutionEntities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.min = this.initShim.min();
        this.initShim = null;
    }

    private ImmutablePollResults(Builder builder) {
        this.results = builder.results == null ? null : ImmutablePollResults.createUnmodifiableList(true, builder.results);
        this.totalVoters = builder.totalVoters;
        this.recentVoters = builder.recentVoters == null ? null : ImmutablePollResults.createUnmodifiableList(true, builder.recentVoters);
        this.solution = builder.solution;
        List<MessageEntity> list = this.solutionEntities = builder.solutionEntities == null ? null : ImmutablePollResults.createUnmodifiableList(true, builder.solutionEntities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.minIsSet()) {
            this.initShim.min(builder.min);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.min = this.initShim.min();
        this.initShim = null;
    }

    private ImmutablePollResults(int identifier, int flags, boolean min, @Nullable List<PollAnswerVoters> results, @Nullable Integer totalVoters, @Nullable List<Long> recentVoters, @Nullable String solution, @Nullable List<MessageEntity> solutionEntities) {
        this.identifier = identifier;
        this.flags = flags;
        this.min = min;
        this.results = results;
        this.totalVoters = totalVoters;
        this.recentVoters = recentVoters;
        this.solution = solution;
        this.solutionEntities = solutionEntities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PollResults.super.identifier();
    }

    private int flagsInitialize() {
        return PollResults.super.flags();
    }

    private boolean minInitialize() {
        return PollResults.super.min();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean min() {
        InitShim shim = this.initShim;
        return shim != null ? shim.min() : this.min;
    }

    @Override
    @Nullable
    public List<PollAnswerVoters> results() {
        return this.results;
    }

    @Override
    @Nullable
    public Integer totalVoters() {
        return this.totalVoters;
    }

    @Override
    @Nullable
    public List<Long> recentVoters() {
        return this.recentVoters;
    }

    @Override
    @Nullable
    public String solution() {
        return this.solution;
    }

    @Override
    @Nullable
    public List<MessageEntity> solutionEntities() {
        return this.solutionEntities;
    }

    public final ImmutablePollResults withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePollResults.validate(new ImmutablePollResults(value, this.flags, this.min, this.results, this.totalVoters, this.recentVoters, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, value, this.min, this.results, this.totalVoters, this.recentVoters, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withMin(boolean value) {
        if (this.min == value) {
            return this;
        }
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, value, this.results, this.totalVoters, this.recentVoters, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withResults(PollAnswerVoters ... elements) {
        if (elements == null) {
            return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, null, this.totalVoters, this.recentVoters, this.solution, this.solutionEntities));
        }
        List<PollAnswerVoters> newValue = Arrays.asList(elements) == null ? null : ImmutablePollResults.createUnmodifiableList(false, ImmutablePollResults.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, newValue, this.totalVoters, this.recentVoters, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withResults(@Nullable Iterable<? extends PollAnswerVoters> elements) {
        if (this.results == elements) {
            return this;
        }
        List<PollAnswerVoters> newValue = elements == null ? null : ImmutablePollResults.createUnmodifiableList(false, ImmutablePollResults.createSafeList(elements, true, false));
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, newValue, this.totalVoters, this.recentVoters, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withTotalVoters(@Nullable Integer value) {
        if (Objects.equals(this.totalVoters, value)) {
            return this;
        }
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, value, this.recentVoters, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withRecentVoters(long ... elements) {
        if (elements == null) {
            return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, null, this.solution, this.solutionEntities));
        }
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutablePollResults.createUnmodifiableList(false, wrappedList);
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, newValue, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withRecentVoters(@Nullable Iterable<Long> elements) {
        if (this.recentVoters == elements) {
            return this;
        }
        List<Long> newValue = elements == null ? null : ImmutablePollResults.createUnmodifiableList(false, ImmutablePollResults.createSafeList(elements, true, false));
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, newValue, this.solution, this.solutionEntities));
    }

    public final ImmutablePollResults withSolution(@Nullable String value) {
        if (Objects.equals(this.solution, value)) {
            return this;
        }
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, this.recentVoters, value, this.solutionEntities));
    }

    public final ImmutablePollResults withSolutionEntities(MessageEntity ... elements) {
        if (elements == null) {
            return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, this.recentVoters, this.solution, null));
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutablePollResults.createUnmodifiableList(false, ImmutablePollResults.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, this.recentVoters, this.solution, newValue));
    }

    public final ImmutablePollResults withSolutionEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.solutionEntities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutablePollResults.createUnmodifiableList(false, ImmutablePollResults.createSafeList(elements, true, false));
        return ImmutablePollResults.validate(new ImmutablePollResults(this.identifier, this.flags, this.min, this.results, this.totalVoters, this.recentVoters, this.solution, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollResults && this.equalTo(0, (ImmutablePollResults)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollResults another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.min == another.min && Objects.equals(this.results, another.results) && Objects.equals(this.totalVoters, another.totalVoters) && Objects.equals(this.recentVoters, another.recentVoters) && Objects.equals(this.solution, another.solution) && Objects.equals(this.solutionEntities, another.solutionEntities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.min);
        h += (h << 5) + Objects.hashCode(this.results);
        h += (h << 5) + Objects.hashCode(this.totalVoters);
        h += (h << 5) + Objects.hashCode(this.recentVoters);
        h += (h << 5) + Objects.hashCode(this.solution);
        h += (h << 5) + Objects.hashCode(this.solutionEntities);
        return h;
    }

    public String toString() {
        return "PollResults{identifier=" + this.identifier + ", flags=" + this.flags + ", min=" + this.min + ", results=" + this.results + ", totalVoters=" + this.totalVoters + ", recentVoters=" + this.recentVoters + ", solution=" + this.solution + ", solutionEntities=" + this.solutionEntities + "}";
    }

    public static ImmutablePollResults of() {
        return INSTANCE;
    }

    private static ImmutablePollResults validate(ImmutablePollResults instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePollResults copyOf(PollResults instance) {
        if (instance instanceof ImmutablePollResults) {
            return (ImmutablePollResults)instance;
        }
        return ImmutablePollResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MIN = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean min;
        private List<PollAnswerVoters> results = null;
        private Integer totalVoters;
        private List<Long> recentVoters = null;
        private String solution;
        private List<MessageEntity> solutionEntities = null;

        private Builder() {
        }

        public final Builder from(PollResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PollResults instance;
            long bits = 0L;
            if (object instanceof PollResults) {
                Integer totalVotersValue;
                List<MessageEntity> solutionEntitiesValue;
                List<Long> recentVotersValue;
                instance = (PollResults)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((recentVotersValue = instance.recentVoters()) != null) {
                    this.addAllRecentVoters(recentVotersValue);
                }
                this.min(instance.min());
                String solutionValue = instance.solution();
                if (solutionValue != null) {
                    this.solution(solutionValue);
                }
                this.flags(instance.flags());
                List<PollAnswerVoters> resultsValue = instance.results();
                if (resultsValue != null) {
                    this.addAllResults(resultsValue);
                }
                if ((solutionEntitiesValue = instance.solutionEntities()) != null) {
                    this.addAllSolutionEntities(solutionEntitiesValue);
                }
                if ((totalVotersValue = instance.totalVoters()) != null) {
                    this.totalVoters(totalVotersValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder min(boolean min) {
            this.min = min;
            this.optBits |= 4L;
            return this;
        }

        public final Builder addResult(PollAnswerVoters element) {
            if (this.results == null) {
                this.results = new ArrayList<PollAnswerVoters>();
            }
            this.results.add(Objects.requireNonNull(element, "results element"));
            return this;
        }

        public final Builder addResults(PollAnswerVoters ... elements) {
            if (this.results == null) {
                this.results = new ArrayList<PollAnswerVoters>();
            }
            for (PollAnswerVoters element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            return this;
        }

        public final Builder results(@Nullable Iterable<? extends PollAnswerVoters> elements) {
            if (elements == null) {
                this.results = null;
                return this;
            }
            this.results = new ArrayList<PollAnswerVoters>();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends PollAnswerVoters> elements) {
            Objects.requireNonNull(elements, "results element");
            if (this.results == null) {
                this.results = new ArrayList<PollAnswerVoters>();
            }
            for (PollAnswerVoters pollAnswerVoters : elements) {
                this.results.add(Objects.requireNonNull(pollAnswerVoters, "results element"));
            }
            return this;
        }

        public final Builder totalVoters(@Nullable Integer totalVoters) {
            this.totalVoters = totalVoters;
            return this;
        }

        public final Builder addRecentVoter(long element) {
            if (this.recentVoters == null) {
                this.recentVoters = new ArrayList<Long>();
            }
            this.recentVoters.add(element);
            return this;
        }

        public final Builder addRecentVoters(long ... elements) {
            if (this.recentVoters == null) {
                this.recentVoters = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.recentVoters.add(element);
            }
            return this;
        }

        public final Builder recentVoters(@Nullable Iterable<Long> elements) {
            if (elements == null) {
                this.recentVoters = null;
                return this;
            }
            this.recentVoters = new ArrayList<Long>();
            return this.addAllRecentVoters(elements);
        }

        public final Builder addAllRecentVoters(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "recentVoters element");
            if (this.recentVoters == null) {
                this.recentVoters = new ArrayList<Long>();
            }
            for (Long element : elements) {
                this.recentVoters.add(Objects.requireNonNull(element, "recentVoters element"));
            }
            return this;
        }

        public final Builder solution(@Nullable String solution) {
            this.solution = solution;
            return this;
        }

        public final Builder addSolutionEntity(MessageEntity element) {
            if (this.solutionEntities == null) {
                this.solutionEntities = new ArrayList<MessageEntity>();
            }
            this.solutionEntities.add(Objects.requireNonNull(element, "solutionEntities element"));
            return this;
        }

        public final Builder addSolutionEntities(MessageEntity ... elements) {
            if (this.solutionEntities == null) {
                this.solutionEntities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.solutionEntities.add(Objects.requireNonNull(element, "solutionEntities element"));
            }
            return this;
        }

        public final Builder solutionEntities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.solutionEntities = null;
                return this;
            }
            this.solutionEntities = new ArrayList<MessageEntity>();
            return this.addAllSolutionEntities(elements);
        }

        public final Builder addAllSolutionEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "solutionEntities element");
            if (this.solutionEntities == null) {
                this.solutionEntities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.solutionEntities.add(Objects.requireNonNull(messageEntity, "solutionEntities element"));
            }
            return this;
        }

        public ImmutablePollResults build() {
            return ImmutablePollResults.validate(new ImmutablePollResults(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean minIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte minBuildStage = 0;
        private boolean min;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePollResults.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePollResults.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean min() {
            if (this.minBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBuildStage == 0) {
                this.minBuildStage = (byte)-1;
                this.min = ImmutablePollResults.this.minInitialize();
                this.minBuildStage = 1;
            }
            return this.min;
        }

        void min(boolean min) {
            this.min = min;
            this.minBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.minBuildStage == -1) {
                attributes.add("min");
            }
            return "Cannot build PollResults, attribute initializers form cycle " + attributes;
        }
    }
}

