/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PopularContact;
import telegram4j.tl.api.TlObject;

public final class ImmutablePopularContact
implements PopularContact {
    private final int identifier;
    private final long clientId;
    private final int importers;

    private ImmutablePopularContact(long clientId, int importers) {
        this.clientId = clientId;
        this.importers = importers;
        this.identifier = PopularContact.super.identifier();
    }

    private ImmutablePopularContact(Builder builder) {
        this.clientId = builder.clientId;
        this.importers = builder.importers;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PopularContact.super.identifier();
    }

    private ImmutablePopularContact(int identifier, long clientId, int importers) {
        this.identifier = identifier;
        this.clientId = clientId;
        this.importers = importers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long clientId() {
        return this.clientId;
    }

    @Override
    public int importers() {
        return this.importers;
    }

    public final ImmutablePopularContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePopularContact(value, this.clientId, this.importers);
    }

    public final ImmutablePopularContact withClientId(long value) {
        if (this.clientId == value) {
            return this;
        }
        return new ImmutablePopularContact(this.identifier, value, this.importers);
    }

    public final ImmutablePopularContact withImporters(int value) {
        if (this.importers == value) {
            return this;
        }
        return new ImmutablePopularContact(this.identifier, this.clientId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePopularContact && this.equalTo(0, (ImmutablePopularContact)another);
    }

    private boolean equalTo(int synthetic, ImmutablePopularContact another) {
        return this.identifier == another.identifier && this.clientId == another.clientId && this.importers == another.importers;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.clientId);
        h += (h << 5) + this.importers;
        return h;
    }

    public String toString() {
        return "PopularContact{identifier=" + this.identifier + ", clientId=" + this.clientId + ", importers=" + this.importers + "}";
    }

    public static ImmutablePopularContact of(long clientId, int importers) {
        return new ImmutablePopularContact(clientId, importers);
    }

    public static ImmutablePopularContact copyOf(PopularContact instance) {
        if (instance instanceof ImmutablePopularContact) {
            return (ImmutablePopularContact)instance;
        }
        return ImmutablePopularContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_IMPORTERS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long clientId;
        private int importers;

        private Builder() {
        }

        public final Builder from(PopularContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PopularContact instance;
            long bits = 0L;
            if (object instanceof PopularContact) {
                instance = (PopularContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.clientId(instance.clientId());
                this.importers(instance.importers());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder clientId(long clientId) {
            this.clientId = clientId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder importers(int importers) {
            this.importers = importers;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePopularContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePopularContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("importers");
            }
            return "Cannot build PopularContact, some of required attributes are not set " + attributes;
        }
    }
}

