/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PostAddress;
import telegram4j.tl.api.TlObject;

public final class ImmutablePostAddress
implements PostAddress {
    private final int identifier;
    private final String streetLine1;
    private final String streetLine2;
    private final String city;
    private final String state;
    private final String countryIso2;
    private final String postCode;

    private ImmutablePostAddress(String streetLine1, String streetLine2, String city, String state, String countryIso2, String postCode) {
        this.streetLine1 = Objects.requireNonNull(streetLine1, "streetLine1");
        this.streetLine2 = Objects.requireNonNull(streetLine2, "streetLine2");
        this.city = Objects.requireNonNull(city, "city");
        this.state = Objects.requireNonNull(state, "state");
        this.countryIso2 = Objects.requireNonNull(countryIso2, "countryIso2");
        this.postCode = Objects.requireNonNull(postCode, "postCode");
        this.identifier = PostAddress.super.identifier();
    }

    private ImmutablePostAddress(Builder builder) {
        this.streetLine1 = builder.streetLine1;
        this.streetLine2 = builder.streetLine2;
        this.city = builder.city;
        this.state = builder.state;
        this.countryIso2 = builder.countryIso2;
        this.postCode = builder.postCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PostAddress.super.identifier();
    }

    private ImmutablePostAddress(int identifier, String streetLine1, String streetLine2, String city, String state, String countryIso2, String postCode) {
        this.identifier = identifier;
        this.streetLine1 = streetLine1;
        this.streetLine2 = streetLine2;
        this.city = city;
        this.state = state;
        this.countryIso2 = countryIso2;
        this.postCode = postCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String streetLine1() {
        return this.streetLine1;
    }

    @Override
    public String streetLine2() {
        return this.streetLine2;
    }

    @Override
    public String city() {
        return this.city;
    }

    @Override
    public String state() {
        return this.state;
    }

    @Override
    public String countryIso2() {
        return this.countryIso2;
    }

    @Override
    public String postCode() {
        return this.postCode;
    }

    public final ImmutablePostAddress withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePostAddress(value, this.streetLine1, this.streetLine2, this.city, this.state, this.countryIso2, this.postCode);
    }

    public final ImmutablePostAddress withStreetLine1(String value) {
        String newValue = Objects.requireNonNull(value, "streetLine1");
        if (this.streetLine1.equals(newValue)) {
            return this;
        }
        return new ImmutablePostAddress(this.identifier, newValue, this.streetLine2, this.city, this.state, this.countryIso2, this.postCode);
    }

    public final ImmutablePostAddress withStreetLine2(String value) {
        String newValue = Objects.requireNonNull(value, "streetLine2");
        if (this.streetLine2.equals(newValue)) {
            return this;
        }
        return new ImmutablePostAddress(this.identifier, this.streetLine1, newValue, this.city, this.state, this.countryIso2, this.postCode);
    }

    public final ImmutablePostAddress withCity(String value) {
        String newValue = Objects.requireNonNull(value, "city");
        if (this.city.equals(newValue)) {
            return this;
        }
        return new ImmutablePostAddress(this.identifier, this.streetLine1, this.streetLine2, newValue, this.state, this.countryIso2, this.postCode);
    }

    public final ImmutablePostAddress withState(String value) {
        String newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals(newValue)) {
            return this;
        }
        return new ImmutablePostAddress(this.identifier, this.streetLine1, this.streetLine2, this.city, newValue, this.countryIso2, this.postCode);
    }

    public final ImmutablePostAddress withCountryIso2(String value) {
        String newValue = Objects.requireNonNull(value, "countryIso2");
        if (this.countryIso2.equals(newValue)) {
            return this;
        }
        return new ImmutablePostAddress(this.identifier, this.streetLine1, this.streetLine2, this.city, this.state, newValue, this.postCode);
    }

    public final ImmutablePostAddress withPostCode(String value) {
        String newValue = Objects.requireNonNull(value, "postCode");
        if (this.postCode.equals(newValue)) {
            return this;
        }
        return new ImmutablePostAddress(this.identifier, this.streetLine1, this.streetLine2, this.city, this.state, this.countryIso2, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePostAddress && this.equalTo(0, (ImmutablePostAddress)another);
    }

    private boolean equalTo(int synthetic, ImmutablePostAddress another) {
        return this.identifier == another.identifier && this.streetLine1.equals(another.streetLine1) && this.streetLine2.equals(another.streetLine2) && this.city.equals(another.city) && this.state.equals(another.state) && this.countryIso2.equals(another.countryIso2) && this.postCode.equals(another.postCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.streetLine1.hashCode();
        h += (h << 5) + this.streetLine2.hashCode();
        h += (h << 5) + this.city.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.countryIso2.hashCode();
        h += (h << 5) + this.postCode.hashCode();
        return h;
    }

    public String toString() {
        return "PostAddress{identifier=" + this.identifier + ", streetLine1=" + this.streetLine1 + ", streetLine2=" + this.streetLine2 + ", city=" + this.city + ", state=" + this.state + ", countryIso2=" + this.countryIso2 + ", postCode=" + this.postCode + "}";
    }

    public static ImmutablePostAddress of(String streetLine1, String streetLine2, String city, String state, String countryIso2, String postCode) {
        return new ImmutablePostAddress(streetLine1, streetLine2, city, state, countryIso2, postCode);
    }

    public static ImmutablePostAddress copyOf(PostAddress instance) {
        if (instance instanceof ImmutablePostAddress) {
            return (ImmutablePostAddress)instance;
        }
        return ImmutablePostAddress.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STREET_LINE1 = 1L;
        private static final long INIT_BIT_STREET_LINE2 = 2L;
        private static final long INIT_BIT_CITY = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private static final long INIT_BIT_COUNTRY_ISO2 = 16L;
        private static final long INIT_BIT_POST_CODE = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private String streetLine1;
        private String streetLine2;
        private String city;
        private String state;
        private String countryIso2;
        private String postCode;

        private Builder() {
        }

        public final Builder from(PostAddress instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PostAddress instance;
            long bits = 0L;
            if (object instanceof PostAddress) {
                instance = (PostAddress)object;
                this.streetLine2(instance.streetLine2());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.streetLine1(instance.streetLine1());
                this.city(instance.city());
                this.postCode(instance.postCode());
                this.state(instance.state());
                this.countryIso2(instance.countryIso2());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder streetLine1(String streetLine1) {
            this.streetLine1 = Objects.requireNonNull(streetLine1, "streetLine1");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder streetLine2(String streetLine2) {
            this.streetLine2 = Objects.requireNonNull(streetLine2, "streetLine2");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder city(String city) {
            this.city = Objects.requireNonNull(city, "city");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder state(String state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder countryIso2(String countryIso2) {
            this.countryIso2 = Objects.requireNonNull(countryIso2, "countryIso2");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder postCode(String postCode) {
            this.postCode = Objects.requireNonNull(postCode, "postCode");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePostAddress build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePostAddress(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("streetLine1");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("streetLine2");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("city");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("countryIso2");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("postCode");
            }
            return "Cannot build PostAddress, some of required attributes are not set " + attributes;
        }
    }
}

