/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PremiumGiftOption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePremiumGiftOption
implements PremiumGiftOption {
    private final int identifier;
    private final int flags;
    private final int months;
    private final String currency;
    private final long amount;
    private final String botUrl;
    @Nullable
    private final String storeProduct;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePremiumGiftOption(int months, String currency, long amount, String botUrl) {
        this.months = months;
        this.currency = Objects.requireNonNull(currency, "currency");
        this.amount = amount;
        this.botUrl = Objects.requireNonNull(botUrl, "botUrl");
        this.storeProduct = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePremiumGiftOption(Builder builder) {
        this.months = builder.months;
        this.currency = builder.currency;
        this.amount = builder.amount;
        this.botUrl = builder.botUrl;
        this.storeProduct = builder.storeProduct;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePremiumGiftOption(int identifier, int flags, int months, String currency, long amount, String botUrl, @Nullable String storeProduct) {
        this.identifier = identifier;
        this.flags = flags;
        this.months = months;
        this.currency = currency;
        this.amount = amount;
        this.botUrl = botUrl;
        this.storeProduct = storeProduct;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PremiumGiftOption.super.identifier();
    }

    private int flagsInitialize() {
        return PremiumGiftOption.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int months() {
        return this.months;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long amount() {
        return this.amount;
    }

    @Override
    public String botUrl() {
        return this.botUrl;
    }

    @Override
    @Nullable
    public String storeProduct() {
        return this.storeProduct;
    }

    public final ImmutablePremiumGiftOption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePremiumGiftOption(value, this.flags, this.months, this.currency, this.amount, this.botUrl, this.storeProduct);
    }

    public final ImmutablePremiumGiftOption withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePremiumGiftOption(this.identifier, value, this.months, this.currency, this.amount, this.botUrl, this.storeProduct);
    }

    public final ImmutablePremiumGiftOption withMonths(int value) {
        if (this.months == value) {
            return this;
        }
        return new ImmutablePremiumGiftOption(this.identifier, this.flags, value, this.currency, this.amount, this.botUrl, this.storeProduct);
    }

    public final ImmutablePremiumGiftOption withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutablePremiumGiftOption(this.identifier, this.flags, this.months, newValue, this.amount, this.botUrl, this.storeProduct);
    }

    public final ImmutablePremiumGiftOption withAmount(long value) {
        if (this.amount == value) {
            return this;
        }
        return new ImmutablePremiumGiftOption(this.identifier, this.flags, this.months, this.currency, value, this.botUrl, this.storeProduct);
    }

    public final ImmutablePremiumGiftOption withBotUrl(String value) {
        String newValue = Objects.requireNonNull(value, "botUrl");
        if (this.botUrl.equals(newValue)) {
            return this;
        }
        return new ImmutablePremiumGiftOption(this.identifier, this.flags, this.months, this.currency, this.amount, newValue, this.storeProduct);
    }

    public final ImmutablePremiumGiftOption withStoreProduct(@Nullable String value) {
        if (Objects.equals(this.storeProduct, value)) {
            return this;
        }
        return new ImmutablePremiumGiftOption(this.identifier, this.flags, this.months, this.currency, this.amount, this.botUrl, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePremiumGiftOption && this.equalTo(0, (ImmutablePremiumGiftOption)another);
    }

    private boolean equalTo(int synthetic, ImmutablePremiumGiftOption another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.months == another.months && this.currency.equals(another.currency) && this.amount == another.amount && this.botUrl.equals(another.botUrl) && Objects.equals(this.storeProduct, another.storeProduct);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.months;
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.amount);
        h += (h << 5) + this.botUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.storeProduct);
        return h;
    }

    public String toString() {
        return "PremiumGiftOption{identifier=" + this.identifier + ", flags=" + this.flags + ", months=" + this.months + ", currency=" + this.currency + ", amount=" + this.amount + ", botUrl=" + this.botUrl + ", storeProduct=" + this.storeProduct + "}";
    }

    public static ImmutablePremiumGiftOption of(int months, String currency, long amount, String botUrl) {
        return new ImmutablePremiumGiftOption(months, currency, amount, botUrl);
    }

    public static ImmutablePremiumGiftOption copyOf(PremiumGiftOption instance) {
        if (instance instanceof ImmutablePremiumGiftOption) {
            return (ImmutablePremiumGiftOption)instance;
        }
        return ImmutablePremiumGiftOption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MONTHS = 1L;
        private static final long INIT_BIT_CURRENCY = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private static final long INIT_BIT_BOT_URL = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private int months;
        private String currency;
        private long amount;
        private String botUrl;
        private String storeProduct;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PremiumGiftOption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PremiumGiftOption) {
                instance = (PremiumGiftOption)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.amount(instance.amount());
                String storeProductValue = instance.storeProduct();
                if (storeProductValue != null) {
                    this.storeProduct(storeProductValue);
                }
                this.months(instance.months());
                this.botUrl(instance.botUrl());
                this.flags(instance.flags());
                this.currency(instance.currency());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder months(int months) {
            this.months = months;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder amount(long amount) {
            this.amount = amount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder botUrl(String botUrl) {
            this.botUrl = Objects.requireNonNull(botUrl, "botUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder storeProduct(@Nullable String storeProduct) {
            this.storeProduct = storeProduct;
            return this;
        }

        public ImmutablePremiumGiftOption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePremiumGiftOption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("months");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("botUrl");
            }
            return "Cannot build PremiumGiftOption, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePremiumGiftOption.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePremiumGiftOption.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PremiumGiftOption, attribute initializers form cycle " + attributes;
        }
    }
}

