/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.PrivacyValueAllowAll;
import telegram4j.tl.api.TlObject;

public final class ImmutablePrivacyValueAllowAll
implements PrivacyValueAllowAll {
    private final int identifier;
    private static final ImmutablePrivacyValueAllowAll INSTANCE = ImmutablePrivacyValueAllowAll.validate(new ImmutablePrivacyValueAllowAll());

    private ImmutablePrivacyValueAllowAll() {
        this.identifier = PrivacyValueAllowAll.super.identifier();
    }

    private ImmutablePrivacyValueAllowAll(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : PrivacyValueAllowAll.super.identifier();
    }

    private ImmutablePrivacyValueAllowAll(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutablePrivacyValueAllowAll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePrivacyValueAllowAll.validate(new ImmutablePrivacyValueAllowAll(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrivacyValueAllowAll && this.equalTo(0, (ImmutablePrivacyValueAllowAll)another);
    }

    private boolean equalTo(int synthetic, ImmutablePrivacyValueAllowAll another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "PrivacyValueAllowAll{identifier=" + this.identifier + "}";
    }

    public static ImmutablePrivacyValueAllowAll of() {
        return INSTANCE;
    }

    private static ImmutablePrivacyValueAllowAll validate(ImmutablePrivacyValueAllowAll instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePrivacyValueAllowAll copyOf(PrivacyValueAllowAll instance) {
        if (instance instanceof ImmutablePrivacyValueAllowAll) {
            return (ImmutablePrivacyValueAllowAll)instance;
        }
        return ImmutablePrivacyValueAllowAll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(PrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PrivacyValueAllowAll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrivacyRule instance;
            long bits = 0L;
            if (object instanceof PrivacyRule) {
                instance = (PrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PrivacyValueAllowAll) {
                instance = (PrivacyValueAllowAll)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePrivacyValueAllowAll build() {
            return ImmutablePrivacyValueAllowAll.validate(new ImmutablePrivacyValueAllowAll(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

