/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.PrivacyValueAllowContacts;
import telegram4j.tl.api.TlObject;

public final class ImmutablePrivacyValueAllowContacts
implements PrivacyValueAllowContacts {
    private final int identifier;
    private static final ImmutablePrivacyValueAllowContacts INSTANCE = ImmutablePrivacyValueAllowContacts.validate(new ImmutablePrivacyValueAllowContacts());

    private ImmutablePrivacyValueAllowContacts() {
        this.identifier = PrivacyValueAllowContacts.super.identifier();
    }

    private ImmutablePrivacyValueAllowContacts(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : PrivacyValueAllowContacts.super.identifier();
    }

    private ImmutablePrivacyValueAllowContacts(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutablePrivacyValueAllowContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePrivacyValueAllowContacts.validate(new ImmutablePrivacyValueAllowContacts(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrivacyValueAllowContacts && this.equalTo(0, (ImmutablePrivacyValueAllowContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutablePrivacyValueAllowContacts another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "PrivacyValueAllowContacts{identifier=" + this.identifier + "}";
    }

    public static ImmutablePrivacyValueAllowContacts of() {
        return INSTANCE;
    }

    private static ImmutablePrivacyValueAllowContacts validate(ImmutablePrivacyValueAllowContacts instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePrivacyValueAllowContacts copyOf(PrivacyValueAllowContacts instance) {
        if (instance instanceof ImmutablePrivacyValueAllowContacts) {
            return (ImmutablePrivacyValueAllowContacts)instance;
        }
        return ImmutablePrivacyValueAllowContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(PrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PrivacyValueAllowContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrivacyRule instance;
            long bits = 0L;
            if (object instanceof PrivacyRule) {
                instance = (PrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PrivacyValueAllowContacts) {
                instance = (PrivacyValueAllowContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePrivacyValueAllowContacts build() {
            return ImmutablePrivacyValueAllowContacts.validate(new ImmutablePrivacyValueAllowContacts(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

