/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.PrivacyValueAllowUsers;
import telegram4j.tl.api.TlObject;

public final class ImmutablePrivacyValueAllowUsers
implements PrivacyValueAllowUsers {
    private final int identifier;
    private final List<Long> users;

    private ImmutablePrivacyValueAllowUsers(Builder builder) {
        this.users = ImmutablePrivacyValueAllowUsers.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PrivacyValueAllowUsers.super.identifier();
    }

    private ImmutablePrivacyValueAllowUsers(int identifier, List<Long> users) {
        this.identifier = identifier;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> users() {
        return this.users;
    }

    public final ImmutablePrivacyValueAllowUsers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePrivacyValueAllowUsers(value, this.users);
    }

    public final ImmutablePrivacyValueAllowUsers withUsers(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutablePrivacyValueAllowUsers.createUnmodifiableList(false, wrappedList);
        return new ImmutablePrivacyValueAllowUsers(this.identifier, newValue);
    }

    public final ImmutablePrivacyValueAllowUsers withUsers(Iterable<Long> elements) {
        if (this.users == elements) {
            return this;
        }
        List<Long> newValue = ImmutablePrivacyValueAllowUsers.createUnmodifiableList(false, ImmutablePrivacyValueAllowUsers.createSafeList(elements, true, false));
        return new ImmutablePrivacyValueAllowUsers(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrivacyValueAllowUsers && this.equalTo(0, (ImmutablePrivacyValueAllowUsers)another);
    }

    private boolean equalTo(int synthetic, ImmutablePrivacyValueAllowUsers another) {
        return this.identifier == another.identifier && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PrivacyValueAllowUsers{identifier=" + this.identifier + ", users=" + this.users + "}";
    }

    public static ImmutablePrivacyValueAllowUsers copyOf(PrivacyValueAllowUsers instance) {
        if (instance instanceof ImmutablePrivacyValueAllowUsers) {
            return (ImmutablePrivacyValueAllowUsers)instance;
        }
        return ImmutablePrivacyValueAllowUsers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> users = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(PrivacyValueAllowUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrivacyRule instance;
            long bits = 0L;
            if (object instanceof PrivacyValueAllowUsers) {
                instance = (PrivacyValueAllowUsers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof PrivacyRule) {
                instance = (PrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addUser(long element) {
            this.users.add(element);
            return this;
        }

        public final Builder addUsers(long ... elements) {
            for (long element : elements) {
                this.users.add(element);
            }
            return this;
        }

        public final Builder users(Iterable<Long> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<Long> elements) {
            for (Long element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public ImmutablePrivacyValueAllowUsers build() {
            return new ImmutablePrivacyValueAllowUsers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

