/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.PrivacyValueDisallowAll;
import telegram4j.tl.api.TlObject;

public final class ImmutablePrivacyValueDisallowAll
implements PrivacyValueDisallowAll {
    private final int identifier;
    private static final ImmutablePrivacyValueDisallowAll INSTANCE = ImmutablePrivacyValueDisallowAll.validate(new ImmutablePrivacyValueDisallowAll());

    private ImmutablePrivacyValueDisallowAll() {
        this.identifier = PrivacyValueDisallowAll.super.identifier();
    }

    private ImmutablePrivacyValueDisallowAll(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : PrivacyValueDisallowAll.super.identifier();
    }

    private ImmutablePrivacyValueDisallowAll(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutablePrivacyValueDisallowAll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePrivacyValueDisallowAll.validate(new ImmutablePrivacyValueDisallowAll(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrivacyValueDisallowAll && this.equalTo(0, (ImmutablePrivacyValueDisallowAll)another);
    }

    private boolean equalTo(int synthetic, ImmutablePrivacyValueDisallowAll another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "PrivacyValueDisallowAll{identifier=" + this.identifier + "}";
    }

    public static ImmutablePrivacyValueDisallowAll of() {
        return INSTANCE;
    }

    private static ImmutablePrivacyValueDisallowAll validate(ImmutablePrivacyValueDisallowAll instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePrivacyValueDisallowAll copyOf(PrivacyValueDisallowAll instance) {
        if (instance instanceof ImmutablePrivacyValueDisallowAll) {
            return (ImmutablePrivacyValueDisallowAll)instance;
        }
        return ImmutablePrivacyValueDisallowAll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(PrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PrivacyValueDisallowAll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrivacyRule instance;
            long bits = 0L;
            if (object instanceof PrivacyRule) {
                instance = (PrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PrivacyValueDisallowAll) {
                instance = (PrivacyValueDisallowAll)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePrivacyValueDisallowAll build() {
            return ImmutablePrivacyValueDisallowAll.validate(new ImmutablePrivacyValueDisallowAll(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

