/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.PrivacyValueDisallowContacts;
import telegram4j.tl.api.TlObject;

public final class ImmutablePrivacyValueDisallowContacts
implements PrivacyValueDisallowContacts {
    private final int identifier;
    private static final ImmutablePrivacyValueDisallowContacts INSTANCE = ImmutablePrivacyValueDisallowContacts.validate(new ImmutablePrivacyValueDisallowContacts());

    private ImmutablePrivacyValueDisallowContacts() {
        this.identifier = PrivacyValueDisallowContacts.super.identifier();
    }

    private ImmutablePrivacyValueDisallowContacts(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : PrivacyValueDisallowContacts.super.identifier();
    }

    private ImmutablePrivacyValueDisallowContacts(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutablePrivacyValueDisallowContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePrivacyValueDisallowContacts.validate(new ImmutablePrivacyValueDisallowContacts(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrivacyValueDisallowContacts && this.equalTo(0, (ImmutablePrivacyValueDisallowContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutablePrivacyValueDisallowContacts another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "PrivacyValueDisallowContacts{identifier=" + this.identifier + "}";
    }

    public static ImmutablePrivacyValueDisallowContacts of() {
        return INSTANCE;
    }

    private static ImmutablePrivacyValueDisallowContacts validate(ImmutablePrivacyValueDisallowContacts instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePrivacyValueDisallowContacts copyOf(PrivacyValueDisallowContacts instance) {
        if (instance instanceof ImmutablePrivacyValueDisallowContacts) {
            return (ImmutablePrivacyValueDisallowContacts)instance;
        }
        return ImmutablePrivacyValueDisallowContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(PrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PrivacyValueDisallowContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrivacyRule instance;
            long bits = 0L;
            if (object instanceof PrivacyRule) {
                instance = (PrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PrivacyValueDisallowContacts) {
                instance = (PrivacyValueDisallowContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePrivacyValueDisallowContacts build() {
            return ImmutablePrivacyValueDisallowContacts.validate(new ImmutablePrivacyValueDisallowContacts(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

