/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ReactionCount;
import telegram4j.tl.api.TlObject;

public final class ImmutableReactionCount
implements ReactionCount {
    private final int identifier;
    private final int flags;
    private final boolean chosen;
    private final String reaction;
    private final int count;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReactionCount(String reaction, int count) {
        this.reaction = Objects.requireNonNull(reaction, "reaction");
        this.count = count;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.chosen = this.initShim.chosen();
        this.initShim = null;
    }

    private ImmutableReactionCount(Builder builder) {
        this.reaction = builder.reaction;
        this.count = builder.count;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.chosenIsSet()) {
            this.initShim.chosen(builder.chosen);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.chosen = this.initShim.chosen();
        this.initShim = null;
    }

    private ImmutableReactionCount(int identifier, int flags, boolean chosen, String reaction, int count) {
        this.identifier = identifier;
        this.flags = flags;
        this.chosen = chosen;
        this.reaction = reaction;
        this.count = count;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReactionCount.super.identifier();
    }

    private int flagsInitialize() {
        return ReactionCount.super.flags();
    }

    private boolean chosenInitialize() {
        return ReactionCount.super.chosen();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean chosen() {
        InitShim shim = this.initShim;
        return shim != null ? shim.chosen() : this.chosen;
    }

    @Override
    public String reaction() {
        return this.reaction;
    }

    @Override
    public int count() {
        return this.count;
    }

    public final ImmutableReactionCount withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReactionCount(value, this.flags, this.chosen, this.reaction, this.count);
    }

    public final ImmutableReactionCount withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableReactionCount(this.identifier, value, this.chosen, this.reaction, this.count);
    }

    public final ImmutableReactionCount withChosen(boolean value) {
        if (this.chosen == value) {
            return this;
        }
        return new ImmutableReactionCount(this.identifier, this.flags, value, this.reaction, this.count);
    }

    public final ImmutableReactionCount withReaction(String value) {
        String newValue = Objects.requireNonNull(value, "reaction");
        if (this.reaction.equals(newValue)) {
            return this;
        }
        return new ImmutableReactionCount(this.identifier, this.flags, this.chosen, newValue, this.count);
    }

    public final ImmutableReactionCount withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableReactionCount(this.identifier, this.flags, this.chosen, this.reaction, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReactionCount && this.equalTo(0, (ImmutableReactionCount)another);
    }

    private boolean equalTo(int synthetic, ImmutableReactionCount another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.chosen == another.chosen && this.reaction.equals(another.reaction) && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.chosen);
        h += (h << 5) + this.reaction.hashCode();
        h += (h << 5) + this.count;
        return h;
    }

    public String toString() {
        return "ReactionCount{identifier=" + this.identifier + ", flags=" + this.flags + ", chosen=" + this.chosen + ", reaction=" + this.reaction + ", count=" + this.count + "}";
    }

    public static ImmutableReactionCount of(String reaction, int count) {
        return new ImmutableReactionCount(reaction, count);
    }

    public static ImmutableReactionCount copyOf(ReactionCount instance) {
        if (instance instanceof ImmutableReactionCount) {
            return (ImmutableReactionCount)instance;
        }
        return ImmutableReactionCount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REACTION = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CHOSEN = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean chosen;
        private String reaction;
        private int count;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReactionCount instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReactionCount) {
                instance = (ReactionCount)object;
                this.flags(instance.flags());
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reaction(instance.reaction());
                this.chosen(instance.chosen());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder chosen(boolean chosen) {
            this.chosen = chosen;
            this.optBits |= 4L;
            return this;
        }

        public final Builder reaction(String reaction) {
            this.reaction = Objects.requireNonNull(reaction, "reaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReactionCount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReactionCount(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean chosenIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build ReactionCount, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte chosenBuildStage = 0;
        private boolean chosen;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReactionCount.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableReactionCount.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean chosen() {
            if (this.chosenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.chosenBuildStage == 0) {
                this.chosenBuildStage = (byte)-1;
                this.chosen = ImmutableReactionCount.this.chosenInitialize();
                this.chosenBuildStage = 1;
            }
            return this.chosen;
        }

        void chosen(boolean chosen) {
            this.chosen = chosen;
            this.chosenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.chosenBuildStage == -1) {
                attributes.add("chosen");
            }
            return "Cannot build ReactionCount, attribute initializers form cycle " + attributes;
        }
    }
}

