/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ReceivedNotifyMessage;
import telegram4j.tl.api.TlObject;

public final class ImmutableReceivedNotifyMessage
implements ReceivedNotifyMessage {
    private final int identifier;
    private final int id;
    private final int flags;

    private ImmutableReceivedNotifyMessage(int id, int flags) {
        this.id = id;
        this.flags = flags;
        this.identifier = ReceivedNotifyMessage.super.identifier();
    }

    private ImmutableReceivedNotifyMessage(Builder builder) {
        this.id = builder.id;
        this.flags = builder.flags;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReceivedNotifyMessage.super.identifier();
    }

    private ImmutableReceivedNotifyMessage(int identifier, int id, int flags) {
        this.identifier = identifier;
        this.id = id;
        this.flags = flags;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    public final ImmutableReceivedNotifyMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReceivedNotifyMessage(value, this.id, this.flags);
    }

    public final ImmutableReceivedNotifyMessage withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableReceivedNotifyMessage(this.identifier, value, this.flags);
    }

    public final ImmutableReceivedNotifyMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableReceivedNotifyMessage(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReceivedNotifyMessage && this.equalTo(0, (ImmutableReceivedNotifyMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableReceivedNotifyMessage another) {
        return this.identifier == another.identifier && this.id == another.id && this.flags == another.flags;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id;
        h += (h << 5) + this.flags;
        return h;
    }

    public String toString() {
        return "ReceivedNotifyMessage{identifier=" + this.identifier + ", id=" + this.id + ", flags=" + this.flags + "}";
    }

    public static ImmutableReceivedNotifyMessage of(int id, int flags) {
        return new ImmutableReceivedNotifyMessage(id, flags);
    }

    public static ImmutableReceivedNotifyMessage copyOf(ReceivedNotifyMessage instance) {
        if (instance instanceof ImmutableReceivedNotifyMessage) {
            return (ImmutableReceivedNotifyMessage)instance;
        }
        return ImmutableReceivedNotifyMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int id;
        private int flags;

        private Builder() {
        }

        public final Builder from(ReceivedNotifyMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReceivedNotifyMessage instance;
            long bits = 0L;
            if (object instanceof ReceivedNotifyMessage) {
                instance = (ReceivedNotifyMessage)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReceivedNotifyMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReceivedNotifyMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("flags");
            }
            return "Cannot build ReceivedNotifyMessage, some of required attributes are not set " + attributes;
        }
    }
}

