/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RecentMeUrl;
import telegram4j.tl.RecentMeUrlChat;
import telegram4j.tl.api.TlObject;

public final class ImmutableRecentMeUrlChat
implements RecentMeUrlChat {
    private final int identifier;
    private final String url;
    private final long chatId;

    private ImmutableRecentMeUrlChat(String url, long chatId) {
        this.url = Objects.requireNonNull(url, "url");
        this.chatId = chatId;
        this.identifier = RecentMeUrlChat.super.identifier();
    }

    private ImmutableRecentMeUrlChat(Builder builder) {
        this.url = builder.url;
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RecentMeUrlChat.super.identifier();
    }

    private ImmutableRecentMeUrlChat(int identifier, String url, long chatId) {
        this.identifier = identifier;
        this.url = url;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    public final ImmutableRecentMeUrlChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRecentMeUrlChat(value, this.url, this.chatId);
    }

    public final ImmutableRecentMeUrlChat withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableRecentMeUrlChat(this.identifier, newValue, this.chatId);
    }

    public final ImmutableRecentMeUrlChat withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableRecentMeUrlChat(this.identifier, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecentMeUrlChat && this.equalTo(0, (ImmutableRecentMeUrlChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecentMeUrlChat another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Long.hashCode(this.chatId);
        return h;
    }

    public String toString() {
        return "RecentMeUrlChat{identifier=" + this.identifier + ", url=" + this.url + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableRecentMeUrlChat of(String url, long chatId) {
        return new ImmutableRecentMeUrlChat(url, chatId);
    }

    public static ImmutableRecentMeUrlChat copyOf(RecentMeUrlChat instance) {
        if (instance instanceof ImmutableRecentMeUrlChat) {
            return (ImmutableRecentMeUrlChat)instance;
        }
        return ImmutableRecentMeUrlChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_CHAT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private long chatId;

        private Builder() {
        }

        public final Builder from(RecentMeUrlChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentMeUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecentMeUrl instance;
            long bits = 0L;
            if (object instanceof RecentMeUrlChat) {
                instance = (RecentMeUrlChat)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RecentMeUrl) {
                instance = (RecentMeUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRecentMeUrlChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecentMeUrlChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build RecentMeUrlChat, some of required attributes are not set " + attributes;
        }
    }
}

