/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatInvite;
import telegram4j.tl.RecentMeUrl;
import telegram4j.tl.RecentMeUrlChatInvite;
import telegram4j.tl.api.TlObject;

public final class ImmutableRecentMeUrlChatInvite
implements RecentMeUrlChatInvite {
    private final int identifier;
    private final String url;
    private final ChatInvite chatInvite;

    private ImmutableRecentMeUrlChatInvite(String url, ChatInvite chatInvite) {
        this.url = Objects.requireNonNull(url, "url");
        this.chatInvite = Objects.requireNonNull(chatInvite, "chatInvite");
        this.identifier = RecentMeUrlChatInvite.super.identifier();
    }

    private ImmutableRecentMeUrlChatInvite(Builder builder) {
        this.url = builder.url;
        this.chatInvite = builder.chatInvite;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RecentMeUrlChatInvite.super.identifier();
    }

    private ImmutableRecentMeUrlChatInvite(int identifier, String url, ChatInvite chatInvite) {
        this.identifier = identifier;
        this.url = url;
        this.chatInvite = chatInvite;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public ChatInvite chatInvite() {
        return this.chatInvite;
    }

    public final ImmutableRecentMeUrlChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRecentMeUrlChatInvite(value, this.url, this.chatInvite);
    }

    public final ImmutableRecentMeUrlChatInvite withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableRecentMeUrlChatInvite(this.identifier, newValue, this.chatInvite);
    }

    public final ImmutableRecentMeUrlChatInvite withChatInvite(ChatInvite value) {
        if (this.chatInvite == value) {
            return this;
        }
        ChatInvite newValue = Objects.requireNonNull(value, "chatInvite");
        return new ImmutableRecentMeUrlChatInvite(this.identifier, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecentMeUrlChatInvite && this.equalTo(0, (ImmutableRecentMeUrlChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecentMeUrlChatInvite another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.chatInvite.equals(another.chatInvite);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.chatInvite.hashCode();
        return h;
    }

    public String toString() {
        return "RecentMeUrlChatInvite{identifier=" + this.identifier + ", url=" + this.url + ", chatInvite=" + this.chatInvite + "}";
    }

    public static ImmutableRecentMeUrlChatInvite of(String url, ChatInvite chatInvite) {
        return new ImmutableRecentMeUrlChatInvite(url, chatInvite);
    }

    public static ImmutableRecentMeUrlChatInvite copyOf(RecentMeUrlChatInvite instance) {
        if (instance instanceof ImmutableRecentMeUrlChatInvite) {
            return (ImmutableRecentMeUrlChatInvite)instance;
        }
        return ImmutableRecentMeUrlChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_CHAT_INVITE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private ChatInvite chatInvite;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentMeUrlChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentMeUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RecentMeUrlChatInvite) {
                instance = (RecentMeUrlChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
                this.chatInvite(instance.chatInvite());
            }
            if (object instanceof RecentMeUrl) {
                instance = (RecentMeUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder chatInvite(ChatInvite chatInvite) {
            this.chatInvite = Objects.requireNonNull(chatInvite, "chatInvite");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRecentMeUrlChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecentMeUrlChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chatInvite");
            }
            return "Cannot build RecentMeUrlChatInvite, some of required attributes are not set " + attributes;
        }
    }
}

