/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RecentMeUrl;
import telegram4j.tl.RecentMeUrlStickerSet;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.api.TlObject;

public final class ImmutableRecentMeUrlStickerSet
implements RecentMeUrlStickerSet {
    private final int identifier;
    private final String url;
    private final StickerSetCovered set;

    private ImmutableRecentMeUrlStickerSet(String url, StickerSetCovered set) {
        this.url = Objects.requireNonNull(url, "url");
        this.set = Objects.requireNonNull(set, "set");
        this.identifier = RecentMeUrlStickerSet.super.identifier();
    }

    private ImmutableRecentMeUrlStickerSet(Builder builder) {
        this.url = builder.url;
        this.set = builder.set;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RecentMeUrlStickerSet.super.identifier();
    }

    private ImmutableRecentMeUrlStickerSet(int identifier, String url, StickerSetCovered set) {
        this.identifier = identifier;
        this.url = url;
        this.set = set;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public StickerSetCovered set() {
        return this.set;
    }

    public final ImmutableRecentMeUrlStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRecentMeUrlStickerSet(value, this.url, this.set);
    }

    public final ImmutableRecentMeUrlStickerSet withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableRecentMeUrlStickerSet(this.identifier, newValue, this.set);
    }

    public final ImmutableRecentMeUrlStickerSet withSet(StickerSetCovered value) {
        if (this.set == value) {
            return this;
        }
        StickerSetCovered newValue = Objects.requireNonNull(value, "set");
        return new ImmutableRecentMeUrlStickerSet(this.identifier, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecentMeUrlStickerSet && this.equalTo(0, (ImmutableRecentMeUrlStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecentMeUrlStickerSet another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.set.equals(another.set);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.set.hashCode();
        return h;
    }

    public String toString() {
        return "RecentMeUrlStickerSet{identifier=" + this.identifier + ", url=" + this.url + ", set=" + this.set + "}";
    }

    public static ImmutableRecentMeUrlStickerSet of(String url, StickerSetCovered set) {
        return new ImmutableRecentMeUrlStickerSet(url, set);
    }

    public static ImmutableRecentMeUrlStickerSet copyOf(RecentMeUrlStickerSet instance) {
        if (instance instanceof ImmutableRecentMeUrlStickerSet) {
            return (ImmutableRecentMeUrlStickerSet)instance;
        }
        return ImmutableRecentMeUrlStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_SET = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private StickerSetCovered set;

        private Builder() {
        }

        public final Builder from(RecentMeUrlStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentMeUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecentMeUrl instance;
            long bits = 0L;
            if (object instanceof RecentMeUrlStickerSet) {
                instance = (RecentMeUrlStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
                this.set(instance.set());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RecentMeUrl) {
                instance = (RecentMeUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder set(StickerSetCovered set) {
            this.set = Objects.requireNonNull(set, "set");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRecentMeUrlStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecentMeUrlStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("set");
            }
            return "Cannot build RecentMeUrlStickerSet, some of required attributes are not set " + attributes;
        }
    }
}

