/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RecentMeUrl;
import telegram4j.tl.RecentMeUrlUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableRecentMeUrlUser
implements RecentMeUrlUser {
    private final int identifier;
    private final String url;
    private final long userId;

    private ImmutableRecentMeUrlUser(String url, long userId) {
        this.url = Objects.requireNonNull(url, "url");
        this.userId = userId;
        this.identifier = RecentMeUrlUser.super.identifier();
    }

    private ImmutableRecentMeUrlUser(Builder builder) {
        this.url = builder.url;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RecentMeUrlUser.super.identifier();
    }

    private ImmutableRecentMeUrlUser(int identifier, String url, long userId) {
        this.identifier = identifier;
        this.url = url;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    public final ImmutableRecentMeUrlUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRecentMeUrlUser(value, this.url, this.userId);
    }

    public final ImmutableRecentMeUrlUser withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableRecentMeUrlUser(this.identifier, newValue, this.userId);
    }

    public final ImmutableRecentMeUrlUser withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableRecentMeUrlUser(this.identifier, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecentMeUrlUser && this.equalTo(0, (ImmutableRecentMeUrlUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecentMeUrlUser another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.userId == another.userId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Long.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "RecentMeUrlUser{identifier=" + this.identifier + ", url=" + this.url + ", userId=" + this.userId + "}";
    }

    public static ImmutableRecentMeUrlUser of(String url, long userId) {
        return new ImmutableRecentMeUrlUser(url, userId);
    }

    public static ImmutableRecentMeUrlUser copyOf(RecentMeUrlUser instance) {
        if (instance instanceof ImmutableRecentMeUrlUser) {
            return (ImmutableRecentMeUrlUser)instance;
        }
        return ImmutableRecentMeUrlUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private long userId;

        private Builder() {
        }

        public final Builder from(RecentMeUrlUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentMeUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecentMeUrl instance;
            long bits = 0L;
            if (object instanceof RecentMeUrlUser) {
                instance = (RecentMeUrlUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RecentMeUrl) {
                instance = (RecentMeUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.url(instance.url());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRecentMeUrlUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecentMeUrlUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build RecentMeUrlUser, some of required attributes are not set " + attributes;
        }
    }
}

