/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.KeyboardButtonRow;
import telegram4j.tl.ReplyInlineMarkup;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableReplyInlineMarkup
implements ReplyInlineMarkup {
    private final int identifier;
    private final List<KeyboardButtonRow> rows;

    private ImmutableReplyInlineMarkup(Builder builder) {
        this.rows = ImmutableReplyInlineMarkup.createUnmodifiableList(true, builder.rows);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReplyInlineMarkup.super.identifier();
    }

    private ImmutableReplyInlineMarkup(int identifier, List<KeyboardButtonRow> rows) {
        this.identifier = identifier;
        this.rows = rows;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<KeyboardButtonRow> rows() {
        return this.rows;
    }

    public final ImmutableReplyInlineMarkup withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReplyInlineMarkup(value, this.rows);
    }

    public final ImmutableReplyInlineMarkup withRows(KeyboardButtonRow ... elements) {
        List<KeyboardButtonRow> newValue = ImmutableReplyInlineMarkup.createUnmodifiableList(false, ImmutableReplyInlineMarkup.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReplyInlineMarkup(this.identifier, newValue);
    }

    public final ImmutableReplyInlineMarkup withRows(Iterable<? extends KeyboardButtonRow> elements) {
        if (this.rows == elements) {
            return this;
        }
        List<KeyboardButtonRow> newValue = ImmutableReplyInlineMarkup.createUnmodifiableList(false, ImmutableReplyInlineMarkup.createSafeList(elements, true, false));
        return new ImmutableReplyInlineMarkup(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplyInlineMarkup && this.equalTo(0, (ImmutableReplyInlineMarkup)another);
    }

    private boolean equalTo(int synthetic, ImmutableReplyInlineMarkup another) {
        return this.identifier == another.identifier && this.rows.equals(another.rows);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.rows.hashCode();
        return h;
    }

    public String toString() {
        return "ReplyInlineMarkup{identifier=" + this.identifier + ", rows=" + this.rows + "}";
    }

    public static ImmutableReplyInlineMarkup copyOf(ReplyInlineMarkup instance) {
        if (instance instanceof ImmutableReplyInlineMarkup) {
            return (ImmutableReplyInlineMarkup)instance;
        }
        return ImmutableReplyInlineMarkup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<KeyboardButtonRow> rows = new ArrayList<KeyboardButtonRow>();

        private Builder() {
        }

        public final Builder from(ReplyMarkup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReplyInlineMarkup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup instance;
            long bits = 0L;
            if (object instanceof ReplyMarkup) {
                instance = (ReplyMarkup)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReplyInlineMarkup) {
                instance = (ReplyInlineMarkup)object;
                this.addAllRows(instance.rows());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addRow(KeyboardButtonRow element) {
            this.rows.add(Objects.requireNonNull(element, "rows element"));
            return this;
        }

        public final Builder addRows(KeyboardButtonRow ... elements) {
            for (KeyboardButtonRow element : elements) {
                this.rows.add(Objects.requireNonNull(element, "rows element"));
            }
            return this;
        }

        public final Builder rows(Iterable<? extends KeyboardButtonRow> elements) {
            this.rows.clear();
            return this.addAllRows(elements);
        }

        public final Builder addAllRows(Iterable<? extends KeyboardButtonRow> elements) {
            for (KeyboardButtonRow keyboardButtonRow : elements) {
                this.rows.add(Objects.requireNonNull(keyboardButtonRow, "rows element"));
            }
            return this;
        }

        public ImmutableReplyInlineMarkup build() {
            return new ImmutableReplyInlineMarkup(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

