/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ReplyKeyboardForceReply;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableReplyKeyboardForceReply
implements ReplyKeyboardForceReply {
    private final int identifier;
    private final int flags;
    private final boolean singleUse;
    private final boolean selective;
    @Nullable
    private final String placeholder;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableReplyKeyboardForceReply INSTANCE = ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply());

    private ImmutableReplyKeyboardForceReply() {
        this.placeholder = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.singleUse = this.initShim.singleUse();
        this.selective = this.initShim.selective();
        this.initShim = null;
    }

    private ImmutableReplyKeyboardForceReply(Builder builder) {
        this.placeholder = builder.placeholder;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.singleUseIsSet()) {
            this.initShim.singleUse(builder.singleUse);
        }
        if (builder.selectiveIsSet()) {
            this.initShim.selective(builder.selective);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.singleUse = this.initShim.singleUse();
        this.selective = this.initShim.selective();
        this.initShim = null;
    }

    private ImmutableReplyKeyboardForceReply(int identifier, int flags, boolean singleUse, boolean selective, @Nullable String placeholder) {
        this.identifier = identifier;
        this.flags = flags;
        this.singleUse = singleUse;
        this.selective = selective;
        this.placeholder = placeholder;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReplyKeyboardForceReply.super.identifier();
    }

    private int flagsInitialize() {
        return ReplyKeyboardForceReply.super.flags();
    }

    private boolean singleUseInitialize() {
        return ReplyKeyboardForceReply.super.singleUse();
    }

    private boolean selectiveInitialize() {
        return ReplyKeyboardForceReply.super.selective();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean singleUse() {
        InitShim shim = this.initShim;
        return shim != null ? shim.singleUse() : this.singleUse;
    }

    @Override
    public boolean selective() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selective() : this.selective;
    }

    @Override
    @Nullable
    public String placeholder() {
        return this.placeholder;
    }

    public final ImmutableReplyKeyboardForceReply withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply(value, this.flags, this.singleUse, this.selective, this.placeholder));
    }

    public final ImmutableReplyKeyboardForceReply withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply(this.identifier, value, this.singleUse, this.selective, this.placeholder));
    }

    public final ImmutableReplyKeyboardForceReply withSingleUse(boolean value) {
        if (this.singleUse == value) {
            return this;
        }
        return ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply(this.identifier, this.flags, value, this.selective, this.placeholder));
    }

    public final ImmutableReplyKeyboardForceReply withSelective(boolean value) {
        if (this.selective == value) {
            return this;
        }
        return ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply(this.identifier, this.flags, this.singleUse, value, this.placeholder));
    }

    public final ImmutableReplyKeyboardForceReply withPlaceholder(@Nullable String value) {
        if (Objects.equals(this.placeholder, value)) {
            return this;
        }
        return ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply(this.identifier, this.flags, this.singleUse, this.selective, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplyKeyboardForceReply && this.equalTo(0, (ImmutableReplyKeyboardForceReply)another);
    }

    private boolean equalTo(int synthetic, ImmutableReplyKeyboardForceReply another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.singleUse == another.singleUse && this.selective == another.selective && Objects.equals(this.placeholder, another.placeholder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.singleUse);
        h += (h << 5) + Boolean.hashCode(this.selective);
        h += (h << 5) + Objects.hashCode(this.placeholder);
        return h;
    }

    public String toString() {
        return "ReplyKeyboardForceReply{identifier=" + this.identifier + ", flags=" + this.flags + ", singleUse=" + this.singleUse + ", selective=" + this.selective + ", placeholder=" + this.placeholder + "}";
    }

    public static ImmutableReplyKeyboardForceReply of() {
        return INSTANCE;
    }

    private static ImmutableReplyKeyboardForceReply validate(ImmutableReplyKeyboardForceReply instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableReplyKeyboardForceReply copyOf(ReplyKeyboardForceReply instance) {
        if (instance instanceof ImmutableReplyKeyboardForceReply) {
            return (ImmutableReplyKeyboardForceReply)instance;
        }
        return ImmutableReplyKeyboardForceReply.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SINGLE_USE = 4L;
        private static final long OPT_BIT_SELECTIVE = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean singleUse;
        private boolean selective;
        private String placeholder;

        private Builder() {
        }

        public final Builder from(ReplyKeyboardForceReply instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReplyMarkup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup instance;
            long bits = 0L;
            if (object instanceof ReplyKeyboardForceReply) {
                String placeholderValue;
                instance = (ReplyKeyboardForceReply)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((placeholderValue = instance.placeholder()) != null) {
                    this.placeholder(placeholderValue);
                }
                this.singleUse(instance.singleUse());
                this.selective(instance.selective());
            }
            if (object instanceof ReplyMarkup) {
                instance = (ReplyMarkup)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder singleUse(boolean singleUse) {
            this.singleUse = singleUse;
            this.optBits |= 4L;
            return this;
        }

        public final Builder selective(boolean selective) {
            this.selective = selective;
            this.optBits |= 8L;
            return this;
        }

        public final Builder placeholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public ImmutableReplyKeyboardForceReply build() {
            return ImmutableReplyKeyboardForceReply.validate(new ImmutableReplyKeyboardForceReply(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean singleUseIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean selectiveIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte singleUseBuildStage = 0;
        private boolean singleUse;
        private byte selectiveBuildStage = 0;
        private boolean selective;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReplyKeyboardForceReply.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableReplyKeyboardForceReply.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean singleUse() {
            if (this.singleUseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.singleUseBuildStage == 0) {
                this.singleUseBuildStage = (byte)-1;
                this.singleUse = ImmutableReplyKeyboardForceReply.this.singleUseInitialize();
                this.singleUseBuildStage = 1;
            }
            return this.singleUse;
        }

        void singleUse(boolean singleUse) {
            this.singleUse = singleUse;
            this.singleUseBuildStage = 1;
        }

        boolean selective() {
            if (this.selectiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selectiveBuildStage == 0) {
                this.selectiveBuildStage = (byte)-1;
                this.selective = ImmutableReplyKeyboardForceReply.this.selectiveInitialize();
                this.selectiveBuildStage = 1;
            }
            return this.selective;
        }

        void selective(boolean selective) {
            this.selective = selective;
            this.selectiveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.singleUseBuildStage == -1) {
                attributes.add("singleUse");
            }
            if (this.selectiveBuildStage == -1) {
                attributes.add("selective");
            }
            return "Cannot build ReplyKeyboardForceReply, attribute initializers form cycle " + attributes;
        }
    }
}

