/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ReplyKeyboardHide;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableReplyKeyboardHide
implements ReplyKeyboardHide {
    private final int identifier;
    private final int flags;
    private final boolean selective;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableReplyKeyboardHide INSTANCE = ImmutableReplyKeyboardHide.validate(new ImmutableReplyKeyboardHide());

    private ImmutableReplyKeyboardHide() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.selective = this.initShim.selective();
        this.initShim = null;
    }

    private ImmutableReplyKeyboardHide(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.selectiveIsSet()) {
            this.initShim.selective(builder.selective);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.selective = this.initShim.selective();
        this.initShim = null;
    }

    private ImmutableReplyKeyboardHide(int identifier, int flags, boolean selective) {
        this.identifier = identifier;
        this.flags = flags;
        this.selective = selective;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReplyKeyboardHide.super.identifier();
    }

    private int flagsInitialize() {
        return ReplyKeyboardHide.super.flags();
    }

    private boolean selectiveInitialize() {
        return ReplyKeyboardHide.super.selective();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean selective() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selective() : this.selective;
    }

    public final ImmutableReplyKeyboardHide withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableReplyKeyboardHide.validate(new ImmutableReplyKeyboardHide(value, this.flags, this.selective));
    }

    public final ImmutableReplyKeyboardHide withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableReplyKeyboardHide.validate(new ImmutableReplyKeyboardHide(this.identifier, value, this.selective));
    }

    public final ImmutableReplyKeyboardHide withSelective(boolean value) {
        if (this.selective == value) {
            return this;
        }
        return ImmutableReplyKeyboardHide.validate(new ImmutableReplyKeyboardHide(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplyKeyboardHide && this.equalTo(0, (ImmutableReplyKeyboardHide)another);
    }

    private boolean equalTo(int synthetic, ImmutableReplyKeyboardHide another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.selective == another.selective;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.selective);
        return h;
    }

    public String toString() {
        return "ReplyKeyboardHide{identifier=" + this.identifier + ", flags=" + this.flags + ", selective=" + this.selective + "}";
    }

    public static ImmutableReplyKeyboardHide of() {
        return INSTANCE;
    }

    private static ImmutableReplyKeyboardHide validate(ImmutableReplyKeyboardHide instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableReplyKeyboardHide copyOf(ReplyKeyboardHide instance) {
        if (instance instanceof ImmutableReplyKeyboardHide) {
            return (ImmutableReplyKeyboardHide)instance;
        }
        return ImmutableReplyKeyboardHide.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SELECTIVE = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean selective;

        private Builder() {
        }

        public final Builder from(ReplyMarkup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReplyKeyboardHide instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup instance;
            long bits = 0L;
            if (object instanceof ReplyMarkup) {
                instance = (ReplyMarkup)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReplyKeyboardHide) {
                instance = (ReplyKeyboardHide)object;
                this.selective(instance.selective());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder selective(boolean selective) {
            this.selective = selective;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableReplyKeyboardHide build() {
            return ImmutableReplyKeyboardHide.validate(new ImmutableReplyKeyboardHide(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean selectiveIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte selectiveBuildStage = 0;
        private boolean selective;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReplyKeyboardHide.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableReplyKeyboardHide.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean selective() {
            if (this.selectiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selectiveBuildStage == 0) {
                this.selectiveBuildStage = (byte)-1;
                this.selective = ImmutableReplyKeyboardHide.this.selectiveInitialize();
                this.selectiveBuildStage = 1;
            }
            return this.selective;
        }

        void selective(boolean selective) {
            this.selective = selective;
            this.selectiveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.selectiveBuildStage == -1) {
                attributes.add("selective");
            }
            return "Cannot build ReplyKeyboardHide, attribute initializers form cycle " + attributes;
        }
    }
}

