/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.KeyboardButtonRow;
import telegram4j.tl.ReplyKeyboardMarkup;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableReplyKeyboardMarkup
implements ReplyKeyboardMarkup {
    private final int identifier;
    private final int flags;
    private final boolean resize;
    private final boolean singleUse;
    private final boolean selective;
    private final List<KeyboardButtonRow> rows;
    @Nullable
    private final String placeholder;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReplyKeyboardMarkup(Builder builder) {
        this.rows = ImmutableReplyKeyboardMarkup.createUnmodifiableList(true, builder.rows);
        this.placeholder = builder.placeholder;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.resizeIsSet()) {
            this.initShim.resize(builder.resize);
        }
        if (builder.singleUseIsSet()) {
            this.initShim.singleUse(builder.singleUse);
        }
        if (builder.selectiveIsSet()) {
            this.initShim.selective(builder.selective);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.resize = this.initShim.resize();
        this.singleUse = this.initShim.singleUse();
        this.selective = this.initShim.selective();
        this.initShim = null;
    }

    private ImmutableReplyKeyboardMarkup(int identifier, int flags, boolean resize, boolean singleUse, boolean selective, List<KeyboardButtonRow> rows, @Nullable String placeholder) {
        this.identifier = identifier;
        this.flags = flags;
        this.resize = resize;
        this.singleUse = singleUse;
        this.selective = selective;
        this.rows = rows;
        this.placeholder = placeholder;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReplyKeyboardMarkup.super.identifier();
    }

    private int flagsInitialize() {
        return ReplyKeyboardMarkup.super.flags();
    }

    private boolean resizeInitialize() {
        return ReplyKeyboardMarkup.super.resize();
    }

    private boolean singleUseInitialize() {
        return ReplyKeyboardMarkup.super.singleUse();
    }

    private boolean selectiveInitialize() {
        return ReplyKeyboardMarkup.super.selective();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean resize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.resize() : this.resize;
    }

    @Override
    public boolean singleUse() {
        InitShim shim = this.initShim;
        return shim != null ? shim.singleUse() : this.singleUse;
    }

    @Override
    public boolean selective() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selective() : this.selective;
    }

    @Override
    public List<KeyboardButtonRow> rows() {
        return this.rows;
    }

    @Override
    @Nullable
    public String placeholder() {
        return this.placeholder;
    }

    public final ImmutableReplyKeyboardMarkup withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReplyKeyboardMarkup(value, this.flags, this.resize, this.singleUse, this.selective, this.rows, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableReplyKeyboardMarkup(this.identifier, value, this.resize, this.singleUse, this.selective, this.rows, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withResize(boolean value) {
        if (this.resize == value) {
            return this;
        }
        return new ImmutableReplyKeyboardMarkup(this.identifier, this.flags, value, this.singleUse, this.selective, this.rows, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withSingleUse(boolean value) {
        if (this.singleUse == value) {
            return this;
        }
        return new ImmutableReplyKeyboardMarkup(this.identifier, this.flags, this.resize, value, this.selective, this.rows, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withSelective(boolean value) {
        if (this.selective == value) {
            return this;
        }
        return new ImmutableReplyKeyboardMarkup(this.identifier, this.flags, this.resize, this.singleUse, value, this.rows, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withRows(KeyboardButtonRow ... elements) {
        List<KeyboardButtonRow> newValue = ImmutableReplyKeyboardMarkup.createUnmodifiableList(false, ImmutableReplyKeyboardMarkup.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReplyKeyboardMarkup(this.identifier, this.flags, this.resize, this.singleUse, this.selective, newValue, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withRows(Iterable<? extends KeyboardButtonRow> elements) {
        if (this.rows == elements) {
            return this;
        }
        List<KeyboardButtonRow> newValue = ImmutableReplyKeyboardMarkup.createUnmodifiableList(false, ImmutableReplyKeyboardMarkup.createSafeList(elements, true, false));
        return new ImmutableReplyKeyboardMarkup(this.identifier, this.flags, this.resize, this.singleUse, this.selective, newValue, this.placeholder);
    }

    public final ImmutableReplyKeyboardMarkup withPlaceholder(@Nullable String value) {
        if (Objects.equals(this.placeholder, value)) {
            return this;
        }
        return new ImmutableReplyKeyboardMarkup(this.identifier, this.flags, this.resize, this.singleUse, this.selective, this.rows, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplyKeyboardMarkup && this.equalTo(0, (ImmutableReplyKeyboardMarkup)another);
    }

    private boolean equalTo(int synthetic, ImmutableReplyKeyboardMarkup another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.resize == another.resize && this.singleUse == another.singleUse && this.selective == another.selective && this.rows.equals(another.rows) && Objects.equals(this.placeholder, another.placeholder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.resize);
        h += (h << 5) + Boolean.hashCode(this.singleUse);
        h += (h << 5) + Boolean.hashCode(this.selective);
        h += (h << 5) + this.rows.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        return h;
    }

    public String toString() {
        return "ReplyKeyboardMarkup{identifier=" + this.identifier + ", flags=" + this.flags + ", resize=" + this.resize + ", singleUse=" + this.singleUse + ", selective=" + this.selective + ", rows=" + this.rows + ", placeholder=" + this.placeholder + "}";
    }

    public static ImmutableReplyKeyboardMarkup copyOf(ReplyKeyboardMarkup instance) {
        if (instance instanceof ImmutableReplyKeyboardMarkup) {
            return (ImmutableReplyKeyboardMarkup)instance;
        }
        return ImmutableReplyKeyboardMarkup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RESIZE = 4L;
        private static final long OPT_BIT_SINGLE_USE = 8L;
        private static final long OPT_BIT_SELECTIVE = 16L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean resize;
        private boolean singleUse;
        private boolean selective;
        private List<KeyboardButtonRow> rows = new ArrayList<KeyboardButtonRow>();
        private String placeholder;

        private Builder() {
        }

        public final Builder from(ReplyKeyboardMarkup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReplyMarkup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup instance;
            long bits = 0L;
            if (object instanceof ReplyKeyboardMarkup) {
                instance = (ReplyKeyboardMarkup)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.singleUse(instance.singleUse());
                this.selective(instance.selective());
                this.flags(instance.flags());
                this.resize(instance.resize());
                String placeholderValue = instance.placeholder();
                if (placeholderValue != null) {
                    this.placeholder(placeholderValue);
                }
                this.addAllRows(instance.rows());
            }
            if (object instanceof ReplyMarkup) {
                instance = (ReplyMarkup)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder resize(boolean resize) {
            this.resize = resize;
            this.optBits |= 4L;
            return this;
        }

        public final Builder singleUse(boolean singleUse) {
            this.singleUse = singleUse;
            this.optBits |= 8L;
            return this;
        }

        public final Builder selective(boolean selective) {
            this.selective = selective;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRow(KeyboardButtonRow element) {
            this.rows.add(Objects.requireNonNull(element, "rows element"));
            return this;
        }

        public final Builder addRows(KeyboardButtonRow ... elements) {
            for (KeyboardButtonRow element : elements) {
                this.rows.add(Objects.requireNonNull(element, "rows element"));
            }
            return this;
        }

        public final Builder rows(Iterable<? extends KeyboardButtonRow> elements) {
            this.rows.clear();
            return this.addAllRows(elements);
        }

        public final Builder addAllRows(Iterable<? extends KeyboardButtonRow> elements) {
            for (KeyboardButtonRow keyboardButtonRow : elements) {
                this.rows.add(Objects.requireNonNull(keyboardButtonRow, "rows element"));
            }
            return this;
        }

        public final Builder placeholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public ImmutableReplyKeyboardMarkup build() {
            return new ImmutableReplyKeyboardMarkup(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean resizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean singleUseIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean selectiveIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte resizeBuildStage = 0;
        private boolean resize;
        private byte singleUseBuildStage = 0;
        private boolean singleUse;
        private byte selectiveBuildStage = 0;
        private boolean selective;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReplyKeyboardMarkup.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableReplyKeyboardMarkup.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean resize() {
            if (this.resizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resizeBuildStage == 0) {
                this.resizeBuildStage = (byte)-1;
                this.resize = ImmutableReplyKeyboardMarkup.this.resizeInitialize();
                this.resizeBuildStage = 1;
            }
            return this.resize;
        }

        void resize(boolean resize) {
            this.resize = resize;
            this.resizeBuildStage = 1;
        }

        boolean singleUse() {
            if (this.singleUseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.singleUseBuildStage == 0) {
                this.singleUseBuildStage = (byte)-1;
                this.singleUse = ImmutableReplyKeyboardMarkup.this.singleUseInitialize();
                this.singleUseBuildStage = 1;
            }
            return this.singleUse;
        }

        void singleUse(boolean singleUse) {
            this.singleUse = singleUse;
            this.singleUseBuildStage = 1;
        }

        boolean selective() {
            if (this.selectiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selectiveBuildStage == 0) {
                this.selectiveBuildStage = (byte)-1;
                this.selective = ImmutableReplyKeyboardMarkup.this.selectiveInitialize();
                this.selectiveBuildStage = 1;
            }
            return this.selective;
        }

        void selective(boolean selective) {
            this.selective = selective;
            this.selectiveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.resizeBuildStage == -1) {
                attributes.add("resize");
            }
            if (this.singleUseBuildStage == -1) {
                attributes.add("singleUse");
            }
            if (this.selectiveBuildStage == -1) {
                attributes.add("selective");
            }
            return "Cannot build ReplyKeyboardMarkup, attribute initializers form cycle " + attributes;
        }
    }
}

