/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RestrictionReason;
import telegram4j.tl.api.TlObject;

public final class ImmutableRestrictionReason
implements RestrictionReason {
    private final int identifier;
    private final String platform;
    private final String reason;
    private final String text;

    private ImmutableRestrictionReason(String platform, String reason, String text) {
        this.platform = Objects.requireNonNull(platform, "platform");
        this.reason = Objects.requireNonNull(reason, "reason");
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = RestrictionReason.super.identifier();
    }

    private ImmutableRestrictionReason(Builder builder) {
        this.platform = builder.platform;
        this.reason = builder.reason;
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RestrictionReason.super.identifier();
    }

    private ImmutableRestrictionReason(int identifier, String platform, String reason, String text) {
        this.identifier = identifier;
        this.platform = platform;
        this.reason = reason;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String platform() {
        return this.platform;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableRestrictionReason withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRestrictionReason(value, this.platform, this.reason, this.text);
    }

    public final ImmutableRestrictionReason withPlatform(String value) {
        String newValue = Objects.requireNonNull(value, "platform");
        if (this.platform.equals(newValue)) {
            return this;
        }
        return new ImmutableRestrictionReason(this.identifier, newValue, this.reason, this.text);
    }

    public final ImmutableRestrictionReason withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (this.reason.equals(newValue)) {
            return this;
        }
        return new ImmutableRestrictionReason(this.identifier, this.platform, newValue, this.text);
    }

    public final ImmutableRestrictionReason withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableRestrictionReason(this.identifier, this.platform, this.reason, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestrictionReason && this.equalTo(0, (ImmutableRestrictionReason)another);
    }

    private boolean equalTo(int synthetic, ImmutableRestrictionReason another) {
        return this.identifier == another.identifier && this.platform.equals(another.platform) && this.reason.equals(another.reason) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "RestrictionReason{identifier=" + this.identifier + ", platform=" + this.platform + ", reason=" + this.reason + ", text=" + this.text + "}";
    }

    public static ImmutableRestrictionReason of(String platform, String reason, String text) {
        return new ImmutableRestrictionReason(platform, reason, text);
    }

    public static ImmutableRestrictionReason copyOf(RestrictionReason instance) {
        if (instance instanceof ImmutableRestrictionReason) {
            return (ImmutableRestrictionReason)instance;
        }
        return ImmutableRestrictionReason.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PLATFORM = 1L;
        private static final long INIT_BIT_REASON = 2L;
        private static final long INIT_BIT_TEXT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String platform;
        private String reason;
        private String text;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RestrictionReason instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RestrictionReason) {
                instance = (RestrictionReason)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reason(instance.reason());
                this.text(instance.text());
                this.platform(instance.platform());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder platform(String platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRestrictionReason build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestrictionReason(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("platform");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reason");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build RestrictionReason, some of required attributes are not set " + attributes;
        }
    }
}

