/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SavedContact;
import telegram4j.tl.api.TlObject;

public final class ImmutableSavedContact
implements SavedContact {
    private final int identifier;
    private final String phone;
    private final String firstName;
    private final String lastName;
    private final int date;

    private ImmutableSavedContact(String phone, String firstName, String lastName, int date) {
        this.phone = Objects.requireNonNull(phone, "phone");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.date = date;
        this.identifier = SavedContact.super.identifier();
    }

    private ImmutableSavedContact(Builder builder) {
        this.phone = builder.phone;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SavedContact.super.identifier();
    }

    private ImmutableSavedContact(int identifier, String phone, String firstName, String lastName, int date) {
        this.identifier = identifier;
        this.phone = phone;
        this.firstName = firstName;
        this.lastName = lastName;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableSavedContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSavedContact(value, this.phone, this.firstName, this.lastName, this.date);
    }

    public final ImmutableSavedContact withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableSavedContact(this.identifier, newValue, this.firstName, this.lastName, this.date);
    }

    public final ImmutableSavedContact withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableSavedContact(this.identifier, this.phone, newValue, this.lastName, this.date);
    }

    public final ImmutableSavedContact withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableSavedContact(this.identifier, this.phone, this.firstName, newValue, this.date);
    }

    public final ImmutableSavedContact withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableSavedContact(this.identifier, this.phone, this.firstName, this.lastName, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSavedContact && this.equalTo(0, (ImmutableSavedContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableSavedContact another) {
        return this.identifier == another.identifier && this.phone.equals(another.phone) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phone.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "SavedContact{identifier=" + this.identifier + ", phone=" + this.phone + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", date=" + this.date + "}";
    }

    public static ImmutableSavedContact of(String phone, String firstName, String lastName, int date) {
        return new ImmutableSavedContact(phone, firstName, lastName, date);
    }

    public static ImmutableSavedContact copyOf(SavedContact instance) {
        if (instance instanceof ImmutableSavedContact) {
            return (ImmutableSavedContact)instance;
        }
        return ImmutableSavedContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE = 1L;
        private static final long INIT_BIT_FIRST_NAME = 2L;
        private static final long INIT_BIT_LAST_NAME = 4L;
        private static final long INIT_BIT_DATE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private String phone;
        private String firstName;
        private String lastName;
        private int date;

        private Builder() {
        }

        public final Builder from(SavedContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SavedContact instance;
            long bits = 0L;
            if (object instanceof SavedContact) {
                instance = (SavedContact)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.phone(instance.phone());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSavedContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSavedContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phone");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build SavedContact, some of required attributes are not set " + attributes;
        }
    }
}

