/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SearchResultsCalendarPeriod;
import telegram4j.tl.api.TlObject;

public final class ImmutableSearchResultsCalendarPeriod
implements SearchResultsCalendarPeriod {
    private final int identifier;
    private final int date;
    private final int minMsgId;
    private final int maxMsgId;
    private final int count;

    private ImmutableSearchResultsCalendarPeriod(int date, int minMsgId, int maxMsgId, int count) {
        this.date = date;
        this.minMsgId = minMsgId;
        this.maxMsgId = maxMsgId;
        this.count = count;
        this.identifier = SearchResultsCalendarPeriod.super.identifier();
    }

    private ImmutableSearchResultsCalendarPeriod(Builder builder) {
        this.date = builder.date;
        this.minMsgId = builder.minMsgId;
        this.maxMsgId = builder.maxMsgId;
        this.count = builder.count;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SearchResultsCalendarPeriod.super.identifier();
    }

    private ImmutableSearchResultsCalendarPeriod(int identifier, int date, int minMsgId, int maxMsgId, int count) {
        this.identifier = identifier;
        this.date = date;
        this.minMsgId = minMsgId;
        this.maxMsgId = maxMsgId;
        this.count = count;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int minMsgId() {
        return this.minMsgId;
    }

    @Override
    public int maxMsgId() {
        return this.maxMsgId;
    }

    @Override
    public int count() {
        return this.count;
    }

    public final ImmutableSearchResultsCalendarPeriod withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendarPeriod(value, this.date, this.minMsgId, this.maxMsgId, this.count);
    }

    public final ImmutableSearchResultsCalendarPeriod withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendarPeriod(this.identifier, value, this.minMsgId, this.maxMsgId, this.count);
    }

    public final ImmutableSearchResultsCalendarPeriod withMinMsgId(int value) {
        if (this.minMsgId == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendarPeriod(this.identifier, this.date, value, this.maxMsgId, this.count);
    }

    public final ImmutableSearchResultsCalendarPeriod withMaxMsgId(int value) {
        if (this.maxMsgId == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendarPeriod(this.identifier, this.date, this.minMsgId, value, this.count);
    }

    public final ImmutableSearchResultsCalendarPeriod withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendarPeriod(this.identifier, this.date, this.minMsgId, this.maxMsgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchResultsCalendarPeriod && this.equalTo(0, (ImmutableSearchResultsCalendarPeriod)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchResultsCalendarPeriod another) {
        return this.identifier == another.identifier && this.date == another.date && this.minMsgId == another.minMsgId && this.maxMsgId == another.maxMsgId && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.date;
        h += (h << 5) + this.minMsgId;
        h += (h << 5) + this.maxMsgId;
        h += (h << 5) + this.count;
        return h;
    }

    public String toString() {
        return "SearchResultsCalendarPeriod{identifier=" + this.identifier + ", date=" + this.date + ", minMsgId=" + this.minMsgId + ", maxMsgId=" + this.maxMsgId + ", count=" + this.count + "}";
    }

    public static ImmutableSearchResultsCalendarPeriod of(int date, int minMsgId, int maxMsgId, int count) {
        return new ImmutableSearchResultsCalendarPeriod(date, minMsgId, maxMsgId, count);
    }

    public static ImmutableSearchResultsCalendarPeriod copyOf(SearchResultsCalendarPeriod instance) {
        if (instance instanceof ImmutableSearchResultsCalendarPeriod) {
            return (ImmutableSearchResultsCalendarPeriod)instance;
        }
        return ImmutableSearchResultsCalendarPeriod.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_MIN_MSG_ID = 2L;
        private static final long INIT_BIT_MAX_MSG_ID = 4L;
        private static final long INIT_BIT_COUNT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int date;
        private int minMsgId;
        private int maxMsgId;
        private int count;

        private Builder() {
        }

        public final Builder from(SearchResultsCalendarPeriod instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SearchResultsCalendarPeriod instance;
            long bits = 0L;
            if (object instanceof SearchResultsCalendarPeriod) {
                instance = (SearchResultsCalendarPeriod)object;
                this.date(instance.date());
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.minMsgId(instance.minMsgId());
                this.maxMsgId(instance.maxMsgId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minMsgId(int minMsgId) {
            this.minMsgId = minMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder maxMsgId(int maxMsgId) {
            this.maxMsgId = maxMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSearchResultsCalendarPeriod build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchResultsCalendarPeriod(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minMsgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("maxMsgId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build SearchResultsCalendarPeriod, some of required attributes are not set " + attributes;
        }
    }
}

