/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SearchResultsPosition;
import telegram4j.tl.api.TlObject;

public final class ImmutableSearchResultsPosition
implements SearchResultsPosition {
    private final int identifier;
    private final int msgId;
    private final int date;
    private final int offset;

    private ImmutableSearchResultsPosition(int msgId, int date, int offset) {
        this.msgId = msgId;
        this.date = date;
        this.offset = offset;
        this.identifier = SearchResultsPosition.super.identifier();
    }

    private ImmutableSearchResultsPosition(Builder builder) {
        this.msgId = builder.msgId;
        this.date = builder.date;
        this.offset = builder.offset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SearchResultsPosition.super.identifier();
    }

    private ImmutableSearchResultsPosition(int identifier, int msgId, int date, int offset) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.date = date;
        this.offset = offset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    public final ImmutableSearchResultsPosition withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchResultsPosition(value, this.msgId, this.date, this.offset);
    }

    public final ImmutableSearchResultsPosition withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableSearchResultsPosition(this.identifier, value, this.date, this.offset);
    }

    public final ImmutableSearchResultsPosition withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableSearchResultsPosition(this.identifier, this.msgId, value, this.offset);
    }

    public final ImmutableSearchResultsPosition withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableSearchResultsPosition(this.identifier, this.msgId, this.date, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchResultsPosition && this.equalTo(0, (ImmutableSearchResultsPosition)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchResultsPosition another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.date == another.date && this.offset == another.offset;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.date;
        h += (h << 5) + this.offset;
        return h;
    }

    public String toString() {
        return "SearchResultsPosition{identifier=" + this.identifier + ", msgId=" + this.msgId + ", date=" + this.date + ", offset=" + this.offset + "}";
    }

    public static ImmutableSearchResultsPosition of(int msgId, int date, int offset) {
        return new ImmutableSearchResultsPosition(msgId, date, offset);
    }

    public static ImmutableSearchResultsPosition copyOf(SearchResultsPosition instance) {
        if (instance instanceof ImmutableSearchResultsPosition) {
            return (ImmutableSearchResultsPosition)instance;
        }
        return ImmutableSearchResultsPosition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_OFFSET = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int msgId;
        private int date;
        private int offset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SearchResultsPosition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SearchResultsPosition) {
                instance = (SearchResultsPosition)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.offset(instance.offset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSearchResultsPosition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchResultsPosition(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build SearchResultsPosition, some of required attributes are not set " + attributes;
        }
    }
}

