/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecureCredentialsEncrypted;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureCredentialsEncrypted
implements SecureCredentialsEncrypted {
    private final int identifier;
    private final ByteBuf data;
    private final ByteBuf hash;
    private final ByteBuf secret;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecureCredentialsEncrypted(Builder builder) {
        this.data = builder.data_build();
        this.hash = builder.hash_build();
        this.secret = builder.secret_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureCredentialsEncrypted(int identifier, ByteBuf data, ByteBuf hash, ByteBuf secret) {
        this.identifier = identifier;
        this.data = data;
        this.hash = hash;
        this.secret = secret;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecureCredentialsEncrypted.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf data() {
        return this.data.duplicate();
    }

    @Override
    public ByteBuf hash() {
        return this.hash.duplicate();
    }

    @Override
    public ByteBuf secret() {
        return this.secret.duplicate();
    }

    public final ImmutableSecureCredentialsEncrypted withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureCredentialsEncrypted(value, this.data, this.hash, this.secret);
    }

    public ImmutableSecureCredentialsEncrypted withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableSecureCredentialsEncrypted(this.identifier, newValue, this.hash, this.secret);
    }

    public ImmutableSecureCredentialsEncrypted withHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.hash == newValue) {
            return this;
        }
        return new ImmutableSecureCredentialsEncrypted(this.identifier, this.data, newValue, this.secret);
    }

    public ImmutableSecureCredentialsEncrypted withSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableSecureCredentialsEncrypted(this.identifier, this.data, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureCredentialsEncrypted && this.equalTo(0, (ImmutableSecureCredentialsEncrypted)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureCredentialsEncrypted another) {
        return this.identifier == another.identifier && this.data().equals((Object)another.data()) && this.hash().equals((Object)another.hash()) && this.secret().equals((Object)another.secret());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.data().hashCode();
        h += (h << 5) + this.hash().hashCode();
        h += (h << 5) + this.secret().hashCode();
        return h;
    }

    public String toString() {
        return "SecureCredentialsEncrypted{identifier=" + this.identifier + ", data=" + ByteBufUtil.hexDump((ByteBuf)this.data) + ", hash=" + ByteBufUtil.hexDump((ByteBuf)this.hash) + ", secret=" + ByteBufUtil.hexDump((ByteBuf)this.secret) + "}";
    }

    public static ImmutableSecureCredentialsEncrypted copyOf(SecureCredentialsEncrypted instance) {
        if (instance instanceof ImmutableSecureCredentialsEncrypted) {
            return (ImmutableSecureCredentialsEncrypted)instance;
        }
        return ImmutableSecureCredentialsEncrypted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf data_value = null;
        private ByteBuf hash_value = null;
        private ByteBuf secret_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SecureCredentialsEncrypted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureCredentialsEncrypted instance;
            long bits = 0L;
            if (object instanceof SecureCredentialsEncrypted) {
                instance = (SecureCredentialsEncrypted)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.secret(instance.secret());
                this.data(instance.data());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder data(ByteBuf value) {
            this.data_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder hash(ByteBuf value) {
            this.hash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder secret(ByteBuf value) {
            this.secret_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSecureCredentialsEncrypted build() {
            return new ImmutableSecureCredentialsEncrypted(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf data_build() {
            return Objects.requireNonNull(this.data_value);
        }

        private ByteBuf hash_build() {
            return Objects.requireNonNull(this.hash_value);
        }

        private ByteBuf secret_build() {
            return Objects.requireNonNull(this.secret_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecureCredentialsEncrypted.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SecureCredentialsEncrypted, attribute initializers form cycle " + attributes;
        }
    }
}

