/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SecureFile;
import telegram4j.tl.SecureFileEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureFileEmpty
implements SecureFileEmpty {
    private final int identifier;
    private static final ImmutableSecureFileEmpty INSTANCE = ImmutableSecureFileEmpty.validate(new ImmutableSecureFileEmpty());

    private ImmutableSecureFileEmpty() {
        this.identifier = SecureFileEmpty.super.identifier();
    }

    private ImmutableSecureFileEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SecureFileEmpty.super.identifier();
    }

    private ImmutableSecureFileEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSecureFileEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSecureFileEmpty.validate(new ImmutableSecureFileEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureFileEmpty && this.equalTo(0, (ImmutableSecureFileEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureFileEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SecureFileEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableSecureFileEmpty of() {
        return INSTANCE;
    }

    private static ImmutableSecureFileEmpty validate(ImmutableSecureFileEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSecureFileEmpty copyOf(SecureFileEmpty instance) {
        if (instance instanceof ImmutableSecureFileEmpty) {
            return (ImmutableSecureFileEmpty)instance;
        }
        return ImmutableSecureFileEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SecureFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureFileEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureFile instance;
            long bits = 0L;
            if (object instanceof SecureFile) {
                instance = (SecureFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecureFileEmpty) {
                instance = (SecureFileEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSecureFileEmpty build() {
            return ImmutableSecureFileEmpty.validate(new ImmutableSecureFileEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

