/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecurePasswordKdfAlgo;
import telegram4j.tl.SecurePasswordKdfAlgoSHA512;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecurePasswordKdfAlgoSHA512
implements SecurePasswordKdfAlgoSHA512 {
    private final int identifier;
    private final ByteBuf salt;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecurePasswordKdfAlgoSHA512(Builder builder) {
        this.salt = builder.salt_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecurePasswordKdfAlgoSHA512(int identifier, ByteBuf salt) {
        this.identifier = identifier;
        this.salt = salt;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecurePasswordKdfAlgoSHA512.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf salt() {
        return this.salt.duplicate();
    }

    public final ImmutableSecurePasswordKdfAlgoSHA512 withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecurePasswordKdfAlgoSHA512(value, this.salt);
    }

    public ImmutableSecurePasswordKdfAlgoSHA512 withSalt(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.salt == newValue) {
            return this;
        }
        return new ImmutableSecurePasswordKdfAlgoSHA512(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecurePasswordKdfAlgoSHA512 && this.equalTo(0, (ImmutableSecurePasswordKdfAlgoSHA512)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecurePasswordKdfAlgoSHA512 another) {
        return this.identifier == another.identifier && this.salt().equals((Object)another.salt());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.salt().hashCode();
        return h;
    }

    public String toString() {
        return "SecurePasswordKdfAlgoSHA512{identifier=" + this.identifier + ", salt=" + ByteBufUtil.hexDump((ByteBuf)this.salt) + "}";
    }

    public static ImmutableSecurePasswordKdfAlgoSHA512 copyOf(SecurePasswordKdfAlgoSHA512 instance) {
        if (instance instanceof ImmutableSecurePasswordKdfAlgoSHA512) {
            return (ImmutableSecurePasswordKdfAlgoSHA512)instance;
        }
        return ImmutableSecurePasswordKdfAlgoSHA512.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf salt_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SecurePasswordKdfAlgoSHA512 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecurePasswordKdfAlgo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecurePasswordKdfAlgo instance;
            long bits = 0L;
            if (object instanceof SecurePasswordKdfAlgoSHA512) {
                instance = (SecurePasswordKdfAlgoSHA512)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.salt(instance.salt());
            }
            if (object instanceof SecurePasswordKdfAlgo) {
                instance = (SecurePasswordKdfAlgo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder salt(ByteBuf value) {
            this.salt_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSecurePasswordKdfAlgoSHA512 build() {
            return new ImmutableSecurePasswordKdfAlgoSHA512(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf salt_build() {
            return Objects.requireNonNull(this.salt_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecurePasswordKdfAlgoSHA512.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SecurePasswordKdfAlgoSHA512, attribute initializers form cycle " + attributes;
        }
    }
}

