/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecurePlainData;
import telegram4j.tl.SecurePlainEmail;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecurePlainEmail
implements SecurePlainEmail {
    private final int identifier;
    private final String email;

    private ImmutableSecurePlainEmail(String email) {
        this.email = Objects.requireNonNull(email, "email");
        this.identifier = SecurePlainEmail.super.identifier();
    }

    private ImmutableSecurePlainEmail(Builder builder) {
        this.email = builder.email;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SecurePlainEmail.super.identifier();
    }

    private ImmutableSecurePlainEmail(int identifier, String email) {
        this.identifier = identifier;
        this.email = email;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String email() {
        return this.email;
    }

    public final ImmutableSecurePlainEmail withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecurePlainEmail(value, this.email);
    }

    public final ImmutableSecurePlainEmail withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (this.email.equals(newValue)) {
            return this;
        }
        return new ImmutableSecurePlainEmail(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecurePlainEmail && this.equalTo(0, (ImmutableSecurePlainEmail)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecurePlainEmail another) {
        return this.identifier == another.identifier && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return "SecurePlainEmail{identifier=" + this.identifier + ", email=" + this.email + "}";
    }

    public static ImmutableSecurePlainEmail of(String email) {
        return new ImmutableSecurePlainEmail(email);
    }

    public static ImmutableSecurePlainEmail copyOf(SecurePlainEmail instance) {
        if (instance instanceof ImmutableSecurePlainEmail) {
            return (ImmutableSecurePlainEmail)instance;
        }
        return ImmutableSecurePlainEmail.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String email;

        private Builder() {
        }

        public final Builder from(SecurePlainData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecurePlainEmail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecurePlainData instance;
            long bits = 0L;
            if (object instanceof SecurePlainData) {
                instance = (SecurePlainData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecurePlainEmail) {
                instance = (SecurePlainEmail)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.email(instance.email());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSecurePlainEmail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecurePlainEmail(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build SecurePlainEmail, some of required attributes are not set " + attributes;
        }
    }
}

