/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecurePlainData;
import telegram4j.tl.SecurePlainPhone;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecurePlainPhone
implements SecurePlainPhone {
    private final int identifier;
    private final String phone;

    private ImmutableSecurePlainPhone(String phone) {
        this.phone = Objects.requireNonNull(phone, "phone");
        this.identifier = SecurePlainPhone.super.identifier();
    }

    private ImmutableSecurePlainPhone(Builder builder) {
        this.phone = builder.phone;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SecurePlainPhone.super.identifier();
    }

    private ImmutableSecurePlainPhone(int identifier, String phone) {
        this.identifier = identifier;
        this.phone = phone;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    public final ImmutableSecurePlainPhone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecurePlainPhone(value, this.phone);
    }

    public final ImmutableSecurePlainPhone withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableSecurePlainPhone(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecurePlainPhone && this.equalTo(0, (ImmutableSecurePlainPhone)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecurePlainPhone another) {
        return this.identifier == another.identifier && this.phone.equals(another.phone);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phone.hashCode();
        return h;
    }

    public String toString() {
        return "SecurePlainPhone{identifier=" + this.identifier + ", phone=" + this.phone + "}";
    }

    public static ImmutableSecurePlainPhone of(String phone) {
        return new ImmutableSecurePlainPhone(phone);
    }

    public static ImmutableSecurePlainPhone copyOf(SecurePlainPhone instance) {
        if (instance instanceof ImmutableSecurePlainPhone) {
            return (ImmutableSecurePlainPhone)instance;
        }
        return ImmutableSecurePlainPhone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String phone;

        private Builder() {
        }

        public final Builder from(SecurePlainData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecurePlainPhone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecurePlainData instance;
            long bits = 0L;
            if (object instanceof SecurePlainData) {
                instance = (SecurePlainData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecurePlainPhone) {
                instance = (SecurePlainPhone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phone(instance.phone());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSecurePlainPhone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecurePlainPhone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phone");
            }
            return "Cannot build SecurePlainPhone, some of required attributes are not set " + attributes;
        }
    }
}

