/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.SecureRequiredType;
import telegram4j.tl.SecureRequiredTypeOneOf;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureRequiredTypeOneOf
implements SecureRequiredTypeOneOf {
    private final int identifier;
    private final List<SecureRequiredType> types;

    private ImmutableSecureRequiredTypeOneOf(Builder builder) {
        this.types = ImmutableSecureRequiredTypeOneOf.createUnmodifiableList(true, builder.types);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SecureRequiredTypeOneOf.super.identifier();
    }

    private ImmutableSecureRequiredTypeOneOf(int identifier, List<SecureRequiredType> types) {
        this.identifier = identifier;
        this.types = types;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<SecureRequiredType> types() {
        return this.types;
    }

    public final ImmutableSecureRequiredTypeOneOf withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureRequiredTypeOneOf(value, this.types);
    }

    public final ImmutableSecureRequiredTypeOneOf withTypes(SecureRequiredType ... elements) {
        List<SecureRequiredType> newValue = ImmutableSecureRequiredTypeOneOf.createUnmodifiableList(false, ImmutableSecureRequiredTypeOneOf.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSecureRequiredTypeOneOf(this.identifier, newValue);
    }

    public final ImmutableSecureRequiredTypeOneOf withTypes(Iterable<? extends SecureRequiredType> elements) {
        if (this.types == elements) {
            return this;
        }
        List<SecureRequiredType> newValue = ImmutableSecureRequiredTypeOneOf.createUnmodifiableList(false, ImmutableSecureRequiredTypeOneOf.createSafeList(elements, true, false));
        return new ImmutableSecureRequiredTypeOneOf(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureRequiredTypeOneOf && this.equalTo(0, (ImmutableSecureRequiredTypeOneOf)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureRequiredTypeOneOf another) {
        return this.identifier == another.identifier && this.types.equals(another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.types.hashCode();
        return h;
    }

    public String toString() {
        return "SecureRequiredTypeOneOf{identifier=" + this.identifier + ", types=" + this.types + "}";
    }

    public static ImmutableSecureRequiredTypeOneOf copyOf(SecureRequiredTypeOneOf instance) {
        if (instance instanceof ImmutableSecureRequiredTypeOneOf) {
            return (ImmutableSecureRequiredTypeOneOf)instance;
        }
        return ImmutableSecureRequiredTypeOneOf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<SecureRequiredType> types = new ArrayList<SecureRequiredType>();

        private Builder() {
        }

        public final Builder from(SecureRequiredTypeOneOf instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureRequiredType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureRequiredType instance;
            long bits = 0L;
            if (object instanceof SecureRequiredTypeOneOf) {
                instance = (SecureRequiredTypeOneOf)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllTypes(instance.types());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecureRequiredType) {
                instance = (SecureRequiredType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addType(SecureRequiredType element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder addTypes(SecureRequiredType ... elements) {
            for (SecureRequiredType element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<? extends SecureRequiredType> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<? extends SecureRequiredType> elements) {
            for (SecureRequiredType secureRequiredType : elements) {
                this.types.add(Objects.requireNonNull(secureRequiredType, "types element"));
            }
            return this;
        }

        public ImmutableSecureRequiredTypeOneOf build() {
            return new ImmutableSecureRequiredTypeOneOf(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

