/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecurePasswordKdfAlgo;
import telegram4j.tl.SecureSecretSettings;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureSecretSettings
implements SecureSecretSettings {
    private final int identifier;
    private final SecurePasswordKdfAlgo secureAlgo;
    private final ByteBuf secureSecret;
    private final long secureSecretId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecureSecretSettings(SecurePasswordKdfAlgo secureAlgo, long secureSecretId) {
        this.secureAlgo = Objects.requireNonNull(secureAlgo, "secureAlgo");
        this.secureSecretId = secureSecretId;
        this.secureSecret = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureSecretSettings(Builder builder) {
        this.secureAlgo = builder.secureAlgo;
        this.secureSecret = builder.secureSecret_build();
        this.secureSecretId = builder.secureSecretId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureSecretSettings(int identifier, SecurePasswordKdfAlgo secureAlgo, ByteBuf secureSecret, long secureSecretId) {
        this.identifier = identifier;
        this.secureAlgo = secureAlgo;
        this.secureSecret = secureSecret;
        this.secureSecretId = secureSecretId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecureSecretSettings.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public SecurePasswordKdfAlgo secureAlgo() {
        return this.secureAlgo;
    }

    @Override
    public ByteBuf secureSecret() {
        return this.secureSecret.duplicate();
    }

    @Override
    public long secureSecretId() {
        return this.secureSecretId;
    }

    public final ImmutableSecureSecretSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureSecretSettings(value, this.secureAlgo, this.secureSecret, this.secureSecretId);
    }

    public final ImmutableSecureSecretSettings withSecureAlgo(SecurePasswordKdfAlgo value) {
        if (this.secureAlgo == value) {
            return this;
        }
        SecurePasswordKdfAlgo newValue = Objects.requireNonNull(value, "secureAlgo");
        return new ImmutableSecureSecretSettings(this.identifier, newValue, this.secureSecret, this.secureSecretId);
    }

    public ImmutableSecureSecretSettings withSecureSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secureSecret == newValue) {
            return this;
        }
        return new ImmutableSecureSecretSettings(this.identifier, this.secureAlgo, newValue, this.secureSecretId);
    }

    public final ImmutableSecureSecretSettings withSecureSecretId(long value) {
        if (this.secureSecretId == value) {
            return this;
        }
        return new ImmutableSecureSecretSettings(this.identifier, this.secureAlgo, this.secureSecret, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureSecretSettings && this.equalTo(0, (ImmutableSecureSecretSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureSecretSettings another) {
        return this.identifier == another.identifier && this.secureAlgo.equals(another.secureAlgo) && this.secureSecret().equals((Object)another.secureSecret()) && this.secureSecretId == another.secureSecretId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.secureAlgo.hashCode();
        h += (h << 5) + this.secureSecret().hashCode();
        h += (h << 5) + Long.hashCode(this.secureSecretId);
        return h;
    }

    public String toString() {
        return "SecureSecretSettings{identifier=" + this.identifier + ", secureAlgo=" + this.secureAlgo + ", secureSecret=" + ByteBufUtil.hexDump((ByteBuf)this.secureSecret) + ", secureSecretId=" + this.secureSecretId + "}";
    }

    public static ImmutableSecureSecretSettings of(SecurePasswordKdfAlgo secureAlgo, long secureSecretId) {
        return new ImmutableSecureSecretSettings(secureAlgo, secureSecretId);
    }

    public static ImmutableSecureSecretSettings copyOf(SecureSecretSettings instance) {
        if (instance instanceof ImmutableSecureSecretSettings) {
            return (ImmutableSecureSecretSettings)instance;
        }
        return ImmutableSecureSecretSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SECURE_ALGO = 1L;
        private static final long INIT_BIT_SECURE_SECRET_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf secureSecret_value = null;
        private int identifier;
        private SecurePasswordKdfAlgo secureAlgo;
        private long secureSecretId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureSecretSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecureSecretSettings) {
                instance = (SecureSecretSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.secureAlgo(instance.secureAlgo());
                this.secureSecretId(instance.secureSecretId());
                this.secureSecret(instance.secureSecret());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder secureAlgo(SecurePasswordKdfAlgo secureAlgo) {
            this.secureAlgo = Objects.requireNonNull(secureAlgo, "secureAlgo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder secureSecret(ByteBuf value) {
            this.secureSecret_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder secureSecretId(long secureSecretId) {
            this.secureSecretId = secureSecretId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSecureSecretSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecureSecretSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("secureAlgo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secureSecretId");
            }
            return "Cannot build SecureSecretSettings, some of required attributes are not set " + attributes;
        }

        private ByteBuf secureSecret_build() {
            return Objects.requireNonNull(this.secureSecret_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecureSecretSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SecureSecretSettings, attribute initializers form cycle " + attributes;
        }
    }
}

